/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.UnsupportedEncodingException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.modeshape.graph.property.Binary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryContains
extends TypeSafeMatcher<Binary> {
    private byte[] expectedContent;

    public BinaryContains(byte[] expectedContent) {
        this.expectedContent = expectedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryContains(Binary expectedContent) {
        try {
            expectedContent.acquire();
            this.expectedContent = expectedContent.getBytes();
        }
        finally {
            expectedContent.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchesSafely(Binary content) {
        try {
            content.acquire();
            byte[] actualContents = content.getBytes();
            if (actualContents.length != this.expectedContent.length) {
                boolean bl = false;
                return bl;
            }
            int len = actualContents.length;
            for (int i = 0; i != len; ++i) {
                if (actualContents[i] == this.expectedContent[i]) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            content.release();
        }
    }

    protected String getDisplayableString(byte[] values) {
        StringBuilder sb = new StringBuilder("byte[]: ");
        sb.append(" len=").append(values.length).append("; [");
        int len = (int)Math.min((long)values.length, 20L);
        for (int i = 0; i != len; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public void describeTo(Description description) {
        description.appendText("a binary containing ").appendValue((Object)this.getDisplayableString(this.expectedContent));
    }

    @Factory
    public static Matcher<Binary> hasContent(Binary expectedContent) {
        return new BinaryContains(expectedContent);
    }

    @Factory
    public static Matcher<Binary> hasContent(String expectedContent) throws UnsupportedEncodingException {
        return new BinaryContains(expectedContent.getBytes("UTF-8"));
    }

    @Factory
    public static Matcher<Binary> hasContent(byte[] expectedContent) {
        return new BinaryContains(expectedContent);
    }

    @Factory
    public static Matcher<Binary> hasNoContent() {
        return new BinaryContains(new byte[0]);
    }
}

