/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.BooleanValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class BooleanValueFactoryTest {
    private NamespaceRegistry registry;
    private BooleanValueFactory factory;
    private StringValueFactory stringFactory;

    @Before
    public void setUp() throws Exception {
        this.registry = new SimpleNamespaceRegistry();
        this.stringFactory = new StringValueFactory(this.registry, Path.URL_DECODER, Path.DEFAULT_ENCODER);
        this.factory = new BooleanValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    @Test
    public void shouldCreateBooleanFromBoolean() {
        Assert.assertThat((Object)this.factory.create(true), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create(false), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateBooleanFromTrueAndFalseStringRegardlessOfCase() {
        Assert.assertThat((Object)this.factory.create("true"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("false"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("TRUE"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("FALSE"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateBooleanFromTrueAndFalseStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  true  "), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("  false  "), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("  TRUE  "), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("  FALSE  "), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateFalseFromStringContainingOneOrZero() {
        Assert.assertThat((Object)this.factory.create("1"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("0"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("  0  "), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("  1  "), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromIntegerValue() {
        this.factory.create(1);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromLongValue() {
        this.factory.create(1L);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromFloatValue() {
        this.factory.create(1.0f);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromDoubleValue() {
        this.factory.create(1.0);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromBigDecimal() {
        this.factory.create(1.0);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromDate() {
        this.factory.create(new Date());
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromCalendar() {
        this.factory.create(Calendar.getInstance());
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromReference() {
        this.factory.create((Reference)Mockito.mock(Reference.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateBooleanFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateBooleanFromByteArrayContainingUtf8EncodingOfTrueOrFalseStringRegardlessOfCase() throws Exception {
        Assert.assertThat((Object)this.factory.create("true".getBytes("UTF-8")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("false".getBytes("UTF-8")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("TRUE".getBytes("UTF-8")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create("FALSE".getBytes("UTF-8")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create("something else".getBytes("UTF-8")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateBooleanFromInputStreamContainingUtf8EncodingOfTrueOrFalseStringRegardlessOfCase() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("true".getBytes("UTF-8"))), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("false".getBytes("UTF-8"))), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("TRUE".getBytes("UTF-8"))), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("FALSE".getBytes("UTF-8"))), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("something else".getBytes("UTF-8"))), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateBooleanFromReaderContainingTrueOrFalseStringRegardlessOfCase() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("true")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("false")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("TRUE")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("FALSE")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("something else")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add(i % 2 == 0 ? "true" : "false");
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.factory.create((String)valueIter.next())));
        }
    }
}

