/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.DecimalValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class DecimalValueFactoryTest {
    private NamespaceRegistry registry;
    private DecimalValueFactory factory;
    private StringValueFactory stringFactory;

    @Before
    public void setUp() throws Exception {
        this.registry = new SimpleNamespaceRegistry();
        this.stringFactory = new StringValueFactory(this.registry, Path.URL_DECODER, Path.DEFAULT_ENCODER);
        this.factory = new DecimalValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromBooleanValue() {
        this.factory.create(true);
    }

    @Test
    public void shouldCreateDecimalFromString() {
        Assert.assertThat((Object)this.factory.create("1"), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)this.factory.create("-1.0"), (Matcher)Is.is((Object)BigDecimal.valueOf(-1.0)));
        Assert.assertThat((Object)this.factory.create("100.000101"), (Matcher)Is.is((Object)BigDecimal.valueOf(100.000101)));
    }

    @Test
    public void shouldCreateDecimalFromStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  1  "), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)this.factory.create("  -1.0  "), (Matcher)Is.is((Object)BigDecimal.valueOf(-1.0)));
        Assert.assertThat((Object)this.factory.create("  100.000101  "), (Matcher)Is.is((Object)BigDecimal.valueOf(100.000101)));
    }

    @Test
    public void shouldCreateDecimalFromIntegerValue() {
        Assert.assertThat((Object)this.factory.create(1), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
    }

    @Test
    public void shouldCreateDecimalFromLongValue() {
        Assert.assertThat((Object)this.factory.create(1L), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
    }

    @Test
    public void shouldCreateDecimalFromFloatValue() {
        Assert.assertThat((Object)this.factory.create(1.0f), (Matcher)Is.is((Object)BigDecimal.valueOf(1.0)));
    }

    @Test
    public void shouldCreateDecimalFromDoubleValue() {
        Assert.assertThat((Object)this.factory.create(1.0), (Matcher)Is.is((Object)BigDecimal.valueOf(1.0)));
    }

    @Test
    public void shouldCreateDecimalFromBigDecimal() {
        BigDecimal value = new BigDecimal(100);
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)value));
    }

    @Test
    public void shouldCreateDecimalFromDate() {
        Date value = new Date();
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)BigDecimal.valueOf(value.getTime())));
    }

    @Test
    public void shouldCreateDecimalFromCalendar() {
        Calendar value = Calendar.getInstance();
        Assert.assertThat((Object)this.factory.create(value), (Matcher)Is.is((Object)BigDecimal.valueOf(value.getTimeInMillis())));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromReference() {
        this.factory.create((Reference)Mockito.mock(Reference.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateDecimalFromByteArrayContainingUtf8EncodingOfStringWithDecimal() throws Exception {
        Assert.assertThat((Object)this.factory.create("1".getBytes("UTF-8")), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)this.factory.create("-1.0".getBytes("UTF-8")), (Matcher)Is.is((Object)BigDecimal.valueOf(-1.0)));
        Assert.assertThat((Object)this.factory.create("100.000101".getBytes("UTF-8")), (Matcher)Is.is((Object)BigDecimal.valueOf(100.000101)));
    }

    @Test
    public void shouldCreateDecimalFromInputStreamContainingUtf8EncodingOfStringWithDecimal() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("1".getBytes("UTF-8"))), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("-1.0".getBytes("UTF-8"))), (Matcher)Is.is((Object)BigDecimal.valueOf(-1.0)));
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream("100.000101".getBytes("UTF-8"))), (Matcher)Is.is((Object)BigDecimal.valueOf(100.000101)));
    }

    @Test
    public void shouldCreateDecimalFromReaderContainingStringWithDecimal() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("1")), (Matcher)Is.is((Object)BigDecimal.valueOf(1L)));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("-1.0")), (Matcher)Is.is((Object)BigDecimal.valueOf(-1.0)));
        Assert.assertThat((Object)this.factory.create((Object)new StringReader("100.000101")), (Matcher)Is.is((Object)BigDecimal.valueOf(100.000101)));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromByteArrayContainingUtf8EncodingOfStringWithContentsOtherThanDecimal() throws Exception {
        this.factory.create("something".getBytes("UTF-8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromInputStreamContainingUtf8EncodingOfStringWithContentsOtherThanDecimal() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDecimalFromReaderContainingStringWithContentsOtherThanDecimal() {
        this.factory.create((Object)new StringReader("something"));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add("" + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.factory.create((String)valueIter.next())));
        }
    }
}

