/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.basic.AbstractNamespaceRegistryTest;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNamespaceRegistryTest
extends AbstractNamespaceRegistryTest<GraphNamespaceRegistry> {
    protected ExecutionContext context;
    protected InMemoryRepositorySource source;
    protected Graph graph;
    private Path pathToParentOfNamespaceNodes;
    private Name uriPropertyName;
    private Name generatedPropertyName;
    private Property[] additionalNamespaceProperties;

    @Override
    public void setUp() {
        super.setUp();
        this.context = new ExecutionContext();
        NameFactory nameFactory = this.context.getValueFactories().getNameFactory();
        PropertyFactory propertyFactory = this.context.getPropertyFactory();
        this.context.getNamespaceRegistry().register("nsx", "http://www.example.com/namespaces");
        this.context.getNamespaceRegistry().register("other", "http://www.example.com/other");
        this.uriPropertyName = (Name)this.context.getValueFactories().getNameFactory().create("nsx:uri");
        this.generatedPropertyName = (Name)this.context.getValueFactories().getNameFactory().create("nsx:gen");
        this.additionalNamespaceProperties = new Property[]{propertyFactory.create((Name)nameFactory.create("nsx:something"), new Object[]{"Some value"}), propertyFactory.create((Name)nameFactory.create("nsx:something2"), new Object[]{"Some value2"}), propertyFactory.create((Name)nameFactory.create("other:something2"), new Object[]{"Some other value2"})};
        this.source = new InMemoryRepositorySource();
        this.source.setName("namespace repository");
        this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.pathToParentOfNamespaceNodes = ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).createAt("/a/b/c").getLocation().getPath();
        this.namespaceRegistry = new GraphNamespaceRegistry(this.graph, this.pathToParentOfNamespaceNodes, this.uriPropertyName, this.generatedPropertyName, this.additionalNamespaceProperties);
    }

    @Override
    protected GraphNamespaceRegistry createNamespaceRegistry() {
        return null;
    }

    @Test
    public void shouldInitializeFromPersistedContent() {
        ((GraphNamespaceRegistry)this.namespaceRegistry).register(this.validPrefix1, this.validNamespaceUri1);
        ((GraphNamespaceRegistry)this.namespaceRegistry).register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
        GraphNamespaceRegistry registry2 = new GraphNamespaceRegistry(this.graph, this.pathToParentOfNamespaceNodes, this.uriPropertyName, this.generatedPropertyName, this.additionalNamespaceProperties);
        Set all = ((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaces();
        Set all2 = registry2.getNamespaces();
        Assert.assertThat((Object)all, (Matcher)Is.is((Object)all2));
        Assert.assertThat((Object)registry2.getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)registry2.getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
        registry2.refresh();
        all2 = registry2.getNamespaces();
        Assert.assertThat((Object)all, (Matcher)Is.is((Object)all2));
        Assert.assertThat((Object)registry2.getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)registry2.getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
    }

    @Test
    public void shouldRefreshFromPersistedContent() {
        ((GraphNamespaceRegistry)this.namespaceRegistry).register(this.validPrefix1, this.validNamespaceUri1);
        ((GraphNamespaceRegistry)this.namespaceRegistry).register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
        Set allBefore = ((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaces();
        ((GraphNamespaceRegistry)this.namespaceRegistry).refresh();
        Set allAfter = ((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaces();
        Assert.assertThat((Object)allBefore, (Matcher)Is.is((Object)allAfter));
        for (NamespaceRegistry.Namespace namespace : allBefore) {
            Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getNamespaceForPrefix(namespace.getPrefix()), (Matcher)Is.is((Object)namespace.getNamespaceUri()));
            Assert.assertThat((Object)((GraphNamespaceRegistry)this.namespaceRegistry).getPrefixForNamespaceUri(namespace.getNamespaceUri(), false), (Matcher)Is.is((Object)namespace.getPrefix()));
        }
    }
}

