/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.basic.BinaryContains;
import org.modeshape.graph.property.basic.InMemoryBinary;

public class InMemoryBinaryTest {
    private byte[] validByteArrayContent;
    private String validStringContent;
    private InMemoryBinary binary;

    @Before
    public void setUp() throws Exception {
        this.validStringContent = "This is a valid string content";
        this.validByteArrayContent = this.validStringContent.getBytes("UTF-8");
        this.binary = new InMemoryBinary(this.validByteArrayContent);
    }

    @Test
    public void shouldConstructFromByteArray() {
        this.binary = new InMemoryBinary(this.validByteArrayContent);
        Assert.assertThat((Object)this.binary.getSize(), (Matcher)Is.is((Object)this.validByteArrayContent.length));
        Assert.assertThat((Object)this.binary, BinaryContains.hasContent(this.validByteArrayContent));
    }

    @Test
    public void shouldConstructFromEmptyByteArray() {
        this.validByteArrayContent = new byte[0];
        this.binary = new InMemoryBinary(this.validByteArrayContent);
        Assert.assertThat((Object)this.binary.getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.binary, BinaryContains.hasNoContent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotConstructFromNullByteArray() {
        new InMemoryBinary(null);
    }

    @Test
    public void shouldHaveSizeThatMatchesContentLength() {
        Assert.assertThat((Object)this.binary.getSize(), (Matcher)Is.is((Object)this.validByteArrayContent.length));
    }

    @Test
    public void shouldProvideInputStreamToContent() throws IOException {
        InputStream stream = this.binary.getStream();
        byte[] actual = IoUtil.readBytes((InputStream)stream);
        Assert.assertThat((Object)actual.length, (Matcher)Is.is((Object)this.validByteArrayContent.length));
        int len = actual.length;
        for (int i = 0; i != len; ++i) {
            Assert.assertThat((Object)actual[i], (Matcher)Is.is((Object)this.validByteArrayContent[i]));
        }
    }

    @Test
    public void shouldConsiderEquivalentThoseInstancesWithSameContent() {
        InMemoryBinary another = new InMemoryBinary(this.validByteArrayContent);
        Assert.assertThat((Object)this.binary.equals((Object)another), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.binary.compareTo((Binary)another), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.binary, (Matcher)Is.is((Object)another));
        Assert.assertThat((Object)this.binary, BinaryContains.hasContent(this.validByteArrayContent));
        Assert.assertThat((Object)another, BinaryContains.hasContent(this.validByteArrayContent));
    }

    @Test
    public void shouldUseSizeWhenComparing() {
        byte[] shorterContent = new byte[this.validByteArrayContent.length - 2];
        for (int i = 0; i != shorterContent.length; ++i) {
            shorterContent[i] = this.validByteArrayContent[i];
        }
        InMemoryBinary another = new InMemoryBinary(shorterContent);
        Assert.assertThat((Object)this.binary.equals((Object)another), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.binary.compareTo((Binary)another), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)another.compareTo((Object)this.binary), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)another, BinaryContains.hasContent(shorterContent));
    }

    @Test
    public void shouldComputeSha1HashOfEmptyContent() throws Exception {
        this.validByteArrayContent = new byte[0];
        this.binary = new InMemoryBinary(this.validByteArrayContent);
        Assert.assertThat((Object)this.binary.getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.binary, BinaryContains.hasNoContent());
        byte[] hash = this.binary.getHash();
        Assert.assertThat((Object)hash.length, (Matcher)Is.is((Object)20));
        Assert.assertThat((Object)StringUtil.getHexString((byte[])hash), (Matcher)Is.is((Object)"da39a3ee5e6b4b0d3255bfef95601890afd80709"));
    }

    @Test
    public void shouldComputeSha1HashOfNonEmptyContent() throws Exception {
        this.binary = new InMemoryBinary(this.validByteArrayContent);
        Assert.assertThat((Object)this.binary.getSize(), (Matcher)Is.is((Object)this.validByteArrayContent.length));
        byte[] hash = this.binary.getHash();
        Assert.assertThat((Object)hash.length, (Matcher)Is.is((Object)20));
        Assert.assertThat((Object)StringUtil.getHexString((byte[])hash), (Matcher)Is.is((Object)"14abe696257e85ba18b7c784d6c7855f46ce50ea"));
    }
}

