/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

public class LocalNamespaceRegistryTest {
    private NamespaceRegistry local;
    private NamespaceRegistry delegate;
    private String uri;

    @Before
    public void beforeEach() {
        this.delegate = new SimpleNamespaceRegistry();
        this.local = new LocalNamespaceRegistry(this.delegate);
        this.uri = "http://www.example.com";
    }

    @Test
    public void shouldMirrorDelegateIfLocalIsEmpty() {
        this.assertNamespaces(this.delegate, "");
        this.assertNamespaces(this.local, "");
    }

    @Test
    public void shouldAllowLocalRegistryToChangeDefaultNamespace() {
        this.local.register("", this.uri);
        this.assertNamespaces(this.delegate, "");
        this.assertNamespaces(this.local, "=" + this.uri);
    }

    protected void assertNamespaces(NamespaceRegistry registry, String ... namespaces) {
        HashMap<String, String> expected = new HashMap<String, String>();
        for (String str : namespaces) {
            String[] stringArray;
            if (str.length() != 0) {
                stringArray = str.split("=");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "";
                stringArray = stringArray2;
                stringArray2[1] = "";
            }
            String[] parts = stringArray;
            Assert.assertThat((String)("invalid namespace string \"" + str + "\""), (Object)parts.length, (Matcher)Is.is((Object)2));
            expected.put(parts[0], parts[1]);
        }
        for (NamespaceRegistry.Namespace actual : registry.getNamespaces()) {
            String expectedUri = (String)expected.remove(actual.getPrefix());
            Assert.assertThat((String)"namespace URIs differ", (Object)actual.getNamespaceUri(), (Matcher)Is.is((Object)expectedUri));
            String prefix = actual.getPrefix();
            String uri = actual.getNamespaceUri();
            Assert.assertThat((Object)registry.isRegisteredNamespaceUri(uri), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)registry.getPrefixForNamespaceUri(uri, false), (Matcher)Is.is((Object)prefix));
            Assert.assertThat((Object)registry.getNamespaceForPrefix(prefix), (Matcher)Is.is((Object)uri));
        }
        if (!expected.isEmpty()) {
            StringBuilder msg = new StringBuilder("actual is missing namespaces ");
            boolean first = true;
            for (Map.Entry entry : expected.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    msg.append(", ");
                }
                msg.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            Assert.assertThat((String)msg.toString(), (Object)registry.getNamespaces().isEmpty(), (Matcher)Is.is((Object)true));
        }
    }
}

