/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.optimize.AddAccessNodes;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class AddAccessNodesTest
extends AbstractQueryTest {
    private AddAccessNodes rule;
    private QueryContext context;

    @Before
    public void beforeEach() {
        this.context = new QueryContext((Schemata)Mockito.mock(Schemata.class), new ExecutionContext().getValueFactories().getTypeSystem());
        this.rule = AddAccessNodes.INSTANCE;
    }

    @Test
    public void shouldAddAccessNodeAboveSourceNode() {
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("Selector1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, project, new SelectorName[]{this.selector("Selector1")});
        PlanNode result = this.rule.execute(this.context, project, new LinkedList());
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)project)));
        PlanNode access = project.getFirstChild();
        Assert.assertThat((Object)access.getType(), (Matcher)Is.is((Object)PlanNode.Type.ACCESS));
        this.assertSelectors(access, "Selector1");
        this.assertChildren(access, source);
        this.assertChildren(source, new PlanNode[0]);
    }
}

