/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

public abstract class AbstractQueryResultsTest
extends AbstractQueryTest {
    protected ExecutionContext executionContext = ExecutionContext.DEFAULT_CONTEXT;
    protected TypeSystem typeSystem = this.executionContext.getValueFactories().getTypeSystem();

    protected Path path(String name) {
        return (Path)this.executionContext.getValueFactories().getPathFactory().create(name);
    }

    protected Schemata schemataFor(QueryResults.Columns columns) {
        return this.schemataFor(columns, new PropertyType[0]);
    }

    protected Schemata schemataFor(QueryResults.Columns columns, PropertyType ... types) {
        ImmutableSchemata.Builder builder = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem);
        for (String selectorName : columns.getSelectorNames()) {
            SelectorName selector = this.selector(selectorName);
            int i = 0;
            for (Column column : columns.getColumns()) {
                PropertyType type;
                String name = column.columnName();
                PropertyType propertyType = type = types != null && types.length > i && types[i] != null ? types[i] : PropertyType.STRING;
                if (!column.selectorName().equals((Object)selector)) continue;
                builder.addColumn(selectorName, name, type.getName().toUpperCase());
                ++i;
            }
        }
        return builder.build();
    }

    protected QueryResults.Columns resultColumns(String selectorName, String[] columnNames, PropertyType ... columnTypes) {
        ArrayList<Column> columnObj = new ArrayList<Column>();
        ArrayList<String> types = new ArrayList<String>();
        SelectorName selector = this.selector(selectorName);
        int i = 0;
        for (String columnName : columnNames) {
            columnObj.add(new Column(selector, columnName, columnName));
            types.add(columnTypes[i++].getName());
        }
        return new QueryResultColumns(columnObj, types, false);
    }

    protected QueryResults.Columns resultColumnsWithSearchResults(String selectorName, String ... columnNames) {
        ArrayList<Column> columnObj = new ArrayList<Column>();
        ArrayList<String> types = new ArrayList<String>();
        SelectorName selector = this.selector(selectorName);
        for (String columnName : columnNames) {
            columnObj.add(new Column(selector, columnName, columnName));
            types.add(PropertyType.STRING.getName());
        }
        return new QueryResultColumns(columnObj, types, true);
    }

    protected Object[] tuple(QueryResults.Columns columns, String path, Object ... values) {
        return this.tuple(columns, this.path(path), values);
    }

    protected Object[] tuple(QueryResults.Columns columns, Path path, Object ... values) {
        return this.tuple(columns, Location.create((Path)path), values);
    }

    protected Object[] tuple(QueryResults.Columns columns, String[] paths, Object ... values) {
        Location[] locations = new Location[paths.length];
        for (int i = 0; i != paths.length; ++i) {
            locations[i] = Location.create((Path)this.path(paths[i]));
        }
        return this.tuple(columns, locations, values);
    }

    protected Object[] tuple(QueryResults.Columns columns, Path[] paths, Object ... values) {
        Location[] locations = new Location[paths.length];
        for (int i = 0; i != paths.length; ++i) {
            locations[i] = Location.create((Path)paths[i]);
        }
        return this.tuple(columns, locations, values);
    }

    protected Object[] tuple(QueryResults.Columns columns, Location location, Object ... values) {
        return this.tuple(columns, new Location[]{location}, values);
    }

    protected Object[] tuple(QueryResults.Columns columns, Location[] locations, Object ... values) {
        Object[] results = new Object[columns.getTupleSize()];
        Assert.assertThat((Object)values.length, (Matcher)Is.is((Object)columns.getColumnCount()));
        for (int i = 0; i != columns.getColumnCount(); ++i) {
            results[i] = values[i];
        }
        int index = columns.getColumnCount();
        for (Location location : locations) {
            results[index++] = location;
        }
        if (columns.hasFullTextSearchScores()) {
            results[index++] = 1.0;
        }
        return results;
    }

    protected Object[] tuple(QueryResults.Columns columns, Location[] locations, double[] scores, Object ... values) {
        Assert.assertThat((Object)values.length, (Matcher)Is.is((Object)columns.getColumnCount()));
        Assert.assertThat((Object)locations.length, (Matcher)Is.is((Object)columns.getLocationCount()));
        Assert.assertThat((Object)scores.length, (Matcher)Is.is((Object)columns.getLocationCount()));
        Object[] results = new Object[columns.getTupleSize()];
        for (int i = 0; i != columns.getColumnCount(); ++i) {
            results[i] = values[i];
        }
        int index = columns.getColumnCount();
        for (Location location : locations) {
            results[index++] = location;
        }
        if (columns.hasFullTextSearchScores()) {
            for (double score : scores) {
                results[index++] = score;
            }
        }
        return results;
    }

    protected Ordering orderByPropertyValue(Column column) {
        return this.orderByPropertyValue(column, Order.ASCENDING);
    }

    protected Ordering orderByPropertyValue(Column column, Order order) {
        return new Ordering((DynamicOperand)new PropertyValue(column.selectorName(), column.propertyName()), order);
    }

    protected Ordering orderByPropertyLength(Column column) {
        return this.orderByPropertyValue(column, Order.ASCENDING);
    }

    protected Ordering orderByPropertyLength(Column column, Order order) {
        return new Ordering((DynamicOperand)new Length(new PropertyValue(column.selectorName(), column.propertyName())), order);
    }

    protected Ordering orderByNodeDepth(String selectorName) {
        return this.orderByNodeDepth(selectorName, Order.ASCENDING);
    }

    protected Ordering orderByNodeDepth(String selectorName, Order order) {
        return new Ordering((DynamicOperand)new NodeDepth(this.selector(selectorName)), order);
    }

    protected Ordering orderByNodePath(String selectorName) {
        return this.orderByNodePath(selectorName, Order.ASCENDING);
    }

    protected Ordering orderByNodePath(String selectorName, Order order) {
        return new Ordering((DynamicOperand)new NodePath(this.selector(selectorName)), order);
    }

    protected Ordering orderByNodeName(String selectorName) {
        return this.orderByNodeName(selectorName, Order.ASCENDING);
    }

    protected Ordering orderByNodeName(String selectorName, Order order) {
        return new Ordering((DynamicOperand)new NodeName(this.selector(selectorName)), order);
    }

    protected Ordering orderByNodeLocalName(String selectorName) {
        return this.orderByNodeLocalName(selectorName, Order.ASCENDING);
    }

    protected Ordering orderByNodeLocalName(String selectorName, Order order) {
        return new Ordering((DynamicOperand)new NodeLocalName(this.selector(selectorName)), order);
    }

    protected Ordering orderByFullTextSearchScore(String selectorName) {
        return this.orderByFullTextSearchScore(selectorName, Order.ASCENDING);
    }

    protected Ordering orderByFullTextSearchScore(String selectorName, Order order) {
        return new Ordering((DynamicOperand)new FullTextSearchScore(this.selector(selectorName)), order);
    }
}

