/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.Request;

public class ReadAllPropertiesRequestTest
extends AbstractRequestTest {
    private ReadAllPropertiesRequest request;

    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    protected Request createRequest() {
        return new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new ReadAllPropertiesRequest(null, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadAllPropertiesRequest(this.validPathLocation1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request.at(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocationsAndWorkspaceNames() {
        this.request = new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace1);
        ReadAllPropertiesRequest request2 = new ReadAllPropertiesRequest(this.validPathLocation1, new String(this.workspace1));
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace1);
        ReadAllPropertiesRequest request2 = new ReadAllPropertiesRequest(this.validPathLocation2, this.workspace1);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace1);
        ReadAllPropertiesRequest request2 = new ReadAllPropertiesRequest(this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowAddingProperties() {
        this.request = new ReadAllPropertiesRequest(this.validPathLocation, this.workspace1);
        this.request.addProperty(this.validProperty1);
        this.request.addProperty(this.validProperty2);
        Assert.assertThat((Object)this.request.getProperties().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.request.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validProperty1, this.validProperty2}));
        Assert.assertThat(this.request.getPropertiesByName().get(this.validProperty1.getName()), (Matcher)Is.is((Object)this.validProperty1));
        Assert.assertThat(this.request.getPropertiesByName().get(this.validProperty2.getName()), (Matcher)Is.is((Object)this.validProperty2));
    }
}

