/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.SelectorName;

@Immutable
class ColumnExpression {
    private final SelectorName selectorName;
    private final String propertyName;
    private final String columnName;
    private final Position position;

    ColumnExpression(SelectorName selectorName, String propertyName, String columnName, Position position) {
        CheckArg.isNotNull(propertyName, "propertyName");
        CheckArg.isNotNull(columnName, "columnName");
        CheckArg.isNotNull(position, "position");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ColumnExpression) {
            ColumnExpression that = (ColumnExpression)obj;
            if (!ObjectUtil.isEqualWithNulls(this.selectorName, that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls(this.propertyName, that.propertyName)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.columnName, that.columnName);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.selectorName != null) {
            sb.append(this.selectorName.name());
            sb.append('.');
        }
        sb.append(this.propertyName);
        if (this.columnName != null) {
            sb.append(" AS ").append(this.columnName);
        }
        return sb.toString();
    }
}

