/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CreateNodeRequest;

public abstract class TransactionalConnectorTest
extends AbstractConnectorTest {
    protected String[] validLargeValues;

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.validLargeValues = new String[]{IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum1.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum2.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum3.txt"))};
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldHaveUpdateCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)true));
    }

    protected void setupInitialData() {
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b/c").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b/d").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).execute();
        Assert.assertThat((Object)this.allChanges.size(), (Matcher)Is.is((Object)1));
        Changes changes = (Changes)this.allChanges.removeFirst();
        Assert.assertThat(changes.getChangeRequests().get(0), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        Assert.assertThat((Object)((ChangeRequest)changes.getChangeRequests().get(0)).changedLocation().getPath(), (Matcher)Is.is((Object)this.path("/a")));
        Assert.assertThat(changes.getChangeRequests().get(1), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        Assert.assertThat((Object)((ChangeRequest)changes.getChangeRequests().get(1)).changedLocation().getPath(), (Matcher)Is.is((Object)this.path("/a/b")));
        Assert.assertThat(changes.getChangeRequests().get(2), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        Assert.assertThat((Object)((ChangeRequest)changes.getChangeRequests().get(2)).changedLocation().getPath(), (Matcher)Is.is((Object)this.path("/a/b/c")));
        Assert.assertThat(changes.getChangeRequests().get(3), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        Assert.assertThat((Object)((ChangeRequest)changes.getChangeRequests().get(3)).changedLocation().getPath(), (Matcher)Is.is((Object)this.path("/a/b/d")));
    }

    protected void assertInitialData() {
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("propB").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("propB").getFirstValue(), (Matcher)Is.is((Object)"valueB"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("propC").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("propC").getFirstValue(), (Matcher)Is.is((Object)"valueC"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b")).getProperty("propB").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b")).getProperty("propB").getFirstValue(), (Matcher)Is.is((Object)"valueB"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b")).getProperty("propC").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b")).getProperty("propC").getFirstValue(), (Matcher)Is.is((Object)"valueC"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/c")).getProperty("propB").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/c")).getProperty("propB").getFirstValue(), (Matcher)Is.is((Object)"valueB"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/c")).getProperty("propC").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/c")).getProperty("propC").getFirstValue(), (Matcher)Is.is((Object)"valueC"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/d")).getProperty("propB").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/d")).getProperty("propB").getFirstValue(), (Matcher)Is.is((Object)"valueB"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/d")).getProperty("propC").isSingle(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/d")).getProperty("propC").getFirstValue(), (Matcher)Is.is((Object)"valueC"));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getChildrenSegments().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(((SubgraphNode)subgraph.getNode("/a")).getChildrenSegments().get(0), (Matcher)Is.is((Object)this.segment("b")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b")).getChildrenSegments().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(((SubgraphNode)subgraph.getNode("/a/b")).getChildrenSegments().get(0), (Matcher)Is.is((Object)this.segment("c")));
        Assert.assertThat(((SubgraphNode)subgraph.getNode("/a/b")).getChildrenSegments().get(1), (Matcher)Is.is((Object)this.segment("d")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/c")).getChildrenSegments().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a/b/d")).getChildrenSegments().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldMakeChangesWithoutErrors() {
        this.setupInitialData();
        this.assertInitialData();
    }

    @Test
    public void shouldBeEmptyAfterCreatingInitialNodesWithFailures() {
        Graph.Batch batch = (Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b/c").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/x/y/z").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b/cx").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and();
        try {
            batch.execute();
            Assert.fail((String)"Expected to get an error");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        Assert.assertThat((Object)this.allChanges.isEmpty(), (Matcher)Is.is((Object)true));
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)root.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotChangePersistedStateAfterMakingMultipleChangesWithOneFailure() {
        this.setupInitialData();
        this.assertInitialData();
        Graph.Batch batch = (Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a/x").with("propD", new Object[]{"valueD"}).and("propE", new Object[]{"valueE"}).and()).create("/a/n/m").with("propF", new Object[]{"valueF"}).and("propG", new Object[]{"valueG"}).and()).create("/a/b/e").with("propH", new Object[]{"valueH"}).and("propC", new Object[]{"valueC"}).and();
        try {
            batch.execute();
            Assert.fail((String)"Expected to get an error");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.allChanges.isEmpty(), (Matcher)Is.is((Object)true));
        this.assertInitialData();
    }
}

