/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StandardValueFactories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueComparatorsTest<T> {
    public static final NamespaceRegistry NAMESPACE_REGISTRY = new SimpleNamespaceRegistry();
    public static final ValueFactories VALUE_FACTORIES = new StandardValueFactories(NAMESPACE_REGISTRY);
    protected final Comparator<T> comparator;
    protected final T[] validNonNullValues;

    protected AbstractValueComparatorsTest(Comparator<T> comparator, T ... validNonNullValues) {
        CheckArg.isNotNull(comparator, (String)"comparator");
        CheckArg.isNotEmpty((Object[])validNonNullValues, (String)"validNonNullValues");
        this.comparator = comparator;
        this.validNonNullValues = validNonNullValues;
    }

    protected Comparator<T> getComparator() {
        return this.comparator;
    }

    @Test
    public void shouldConsiderNullLessThanValidNonNull() {
        Assert.assertThat((Object)(this.comparator.compare(this.validNonNullValues[0], null) > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(this.comparator.compare(null, this.validNonNullValues[0]) < 0 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderTwoNullsToBeEquivalent() {
        Assert.assertThat((Object)this.comparator.compare(null, null), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldConsiderSameInstanceToBeEquivalent() {
        for (T validNonNullValue : this.validNonNullValues) {
            Assert.assertThat((Object)this.comparator.compare(validNonNullValue, validNonNullValue), (Matcher)Is.is((Object)0));
        }
    }

    protected List<T> getValues(boolean includeNull) {
        ArrayList<T> values = new ArrayList<T>(this.validNonNullValues.length);
        for (T validNonNullValue : this.validNonNullValues) {
            Assert.assertThat(validNonNullValue, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            values.add(validNonNullValue);
        }
        if (includeNull) {
            values.add(null);
        }
        return values;
    }

    protected List<T> getSortedValues(boolean includeNull) {
        List<T> values = this.getValues(includeNull);
        Collections.sort(values, this.comparator);
        return values;
    }

    @Test
    public void shouldBeCompatibleWithCompareTo() {
        List<T> values = this.getValues(false);
        Collections.sort(values, this.comparator);
        for (int i = 0; i != values.size() - 1; ++i) {
            T value1 = values.get(i);
            T value2 = values.get(i + 1);
            Assert.assertThat(value1, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Comparable.class)));
            Comparable comparable1 = (Comparable)value1;
            int result = comparable1.compareTo(value2);
            Assert.assertThat((Object)(result < 0 || result == 0 ? 1 : 0), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)comparable1.compareTo(value1), (Matcher)Is.is((Object)0));
        }
    }

    protected void assertValuesCompareUsing(T value1, T value2) {
        int value1ToValue2 = this.comparator.compare(value1, value2);
        int value2ToValue1 = this.comparator.compare(value2, value1);
        if (value1ToValue2 == 0) {
            Assert.assertThat((Object)value2ToValue1, (Matcher)Is.is((Object)0));
        } else if (value1ToValue2 < 0) {
            Assert.assertThat((Object)(value2ToValue1 > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        } else {
            Assert.assertThat((Object)(value2ToValue1 < 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        }
    }
}

