/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BinaryContains;
import org.modeshape.graph.property.basic.InMemoryBinaryValueFactory;
import org.modeshape.graph.property.basic.JodaDateTime;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;
import org.modeshape.graph.property.basic.UuidReference;

public class InMemoryBinaryValueFactoryTest {
    private InMemoryBinaryValueFactory factory;
    private StringValueFactory stringFactory;
    private NameValueFactory nameFactory;
    private NamespaceRegistry namespaceRegistry;
    private PathValueFactory pathFactory;
    private TextEncoder encoder;

    @Before
    public void setUp() throws Exception {
        this.encoder = Path.URL_ENCODER;
        this.namespaceRegistry = new SimpleNamespaceRegistry();
        this.namespaceRegistry.register("jboss", "http://www.jboss.org");
        this.namespaceRegistry.register("dna", "http://www.modeshape.org");
        this.stringFactory = new StringValueFactory(this.namespaceRegistry, Path.URL_DECODER, this.encoder);
        this.nameFactory = new NameValueFactory(this.namespaceRegistry, Path.URL_DECODER, (ValueFactory)this.stringFactory);
        this.pathFactory = new PathValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory, (ValueFactory)this.nameFactory);
        StringValueFactory noNamespaceStringFactory = new StringValueFactory(Path.URL_DECODER, this.encoder);
        this.factory = new InMemoryBinaryValueFactory(Path.URL_DECODER, (ValueFactory)noNamespaceStringFactory);
    }

    @Test
    public void shouldCreateBinaryFromBooleanValue() {
        this.factory.create(true);
    }

    @Test
    public void shouldCreateDecimalFromString() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create("1"), BinaryContains.hasContent("1"));
        Assert.assertThat((Object)this.factory.create("-1.0"), BinaryContains.hasContent("-1.0"));
        Assert.assertThat((Object)this.factory.create("100.000101"), BinaryContains.hasContent("100.000101"));
        Assert.assertThat((Object)this.factory.create("quick brown fox."), BinaryContains.hasContent("quick brown fox."));
    }

    @Test
    public void shouldCreateBinaryFromStringIncludingfLeadingAndTrailingWhitespace() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create("   1   "), BinaryContains.hasContent("   1   "));
        Assert.assertThat((Object)this.factory.create("   -1.0   "), BinaryContains.hasContent("   -1.0   "));
        Assert.assertThat((Object)this.factory.create("   100.000101   "), BinaryContains.hasContent("   100.000101   "));
        Assert.assertThat((Object)this.factory.create("   quick brown fox.   "), BinaryContains.hasContent("   quick brown fox.   "));
    }

    @Test
    public void shouldCreateBinaryFromIntegerValue() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create(1), BinaryContains.hasContent(Integer.toString(1)));
        Assert.assertThat((Object)this.factory.create(-1), BinaryContains.hasContent(Integer.toString(-1)));
        Assert.assertThat((Object)this.factory.create(123456), BinaryContains.hasContent(Integer.toString(123456)));
    }

    @Test
    public void shouldCreateBinaryFromLongValue() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create(1L), BinaryContains.hasContent(Long.toString(1L)));
        Assert.assertThat((Object)this.factory.create(-1L), BinaryContains.hasContent(Long.toString(-1L)));
        Assert.assertThat((Object)this.factory.create(123456L), BinaryContains.hasContent(Long.toString(123456L)));
    }

    @Test
    public void shouldCreateBinaryFromFloatValue() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create(1.0f), BinaryContains.hasContent(Float.toString(1.0f)));
        Assert.assertThat((Object)this.factory.create(-1.0f), BinaryContains.hasContent(Float.toString(-1.0f)));
        Assert.assertThat((Object)this.factory.create(123456.23f), BinaryContains.hasContent(Float.toString(123456.23f)));
    }

    @Test
    public void shouldCreateBinaryFromDoubleValue() throws UnsupportedEncodingException {
        Assert.assertThat((Object)this.factory.create(1.0), BinaryContains.hasContent(Double.toString(1.0)));
        Assert.assertThat((Object)this.factory.create(-1.0), BinaryContains.hasContent(Double.toString(-1.0)));
        Assert.assertThat((Object)this.factory.create(123456.23), BinaryContains.hasContent(Double.toString(123456.23)));
    }

    @Test
    public void shouldCreateBinaryFromBigDecimal() throws UnsupportedEncodingException {
        BigDecimal value = new BigDecimal(100);
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent(value.toString()));
    }

    @Test
    public void shouldCreateBinaryFromDate() throws UnsupportedEncodingException {
        Date value = new Date();
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent(new JodaDateTime(value).toString()));
    }

    @Test
    public void shouldCreateBinaryFromCalendar() throws UnsupportedEncodingException {
        Calendar value = Calendar.getInstance();
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent(new JodaDateTime(value).toString()));
    }

    @Test
    public void shouldCreateBinaryFromName() throws UnsupportedEncodingException {
        Name value = this.nameFactory.create("jboss:localName");
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent("{" + this.encoder.encode("http://www.jboss.org") + "}" + this.encoder.encode("localName")));
    }

    @Test
    public void shouldCreateBinaryFromPath() throws UnsupportedEncodingException {
        Path value = this.pathFactory.create("/a/b/c/jboss:localName");
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent("/{}a/{}b/{}c/{" + this.encoder.encode("http://www.jboss.org") + "}" + this.encoder.encode("localName")));
    }

    @Test
    public void shouldCreateBinaryFromReference() throws UnsupportedEncodingException {
        UUID uuid = UUID.randomUUID();
        UuidReference value = new UuidReference(uuid);
        Assert.assertThat((Object)this.factory.create((Reference)value), BinaryContains.hasContent(uuid.toString()));
    }

    @Test
    public void shouldCreateBinaryFromUri() throws Exception {
        URI value = new URI("http://www.jboss.org");
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateBinaryFromByteArray() throws Exception {
        byte[] value = "Some byte string".getBytes("UTF-8");
        Assert.assertThat((Object)this.factory.create(value), BinaryContains.hasContent(value));
    }

    @Test
    public void shouldCreateBinaryFromInputStream() throws Exception {
        String value = "Some test string";
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream(value.getBytes("UTF-8"))), BinaryContains.hasContent(value));
    }

    @Test
    public void shouldCreateBinaryFromReader() throws Exception {
        String value = "Some test string";
        Assert.assertThat((Object)this.factory.create((Object)new StringReader(value)), BinaryContains.hasContent(value));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add("some string" + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)this.factory.create((String)valueIter.next())));
        }
    }
}

