/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CompositeRequestChannel;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineProcessor;

@ThreadSafe
public class SearchableRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = 1L;
    private final RepositorySource delegate;
    private final boolean executeAsynchronously;
    private final boolean updateIndexesAsynchronously;
    private final transient ExecutorService executorService;
    private final transient SearchEngine searchEngine;

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine, ExecutorService executorService, boolean executeAsynchronously, boolean updateIndexesAsynchronously) {
        CheckArg.isNotNull((Object)wrapped, (String)"wrapped");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        this.delegate = wrapped;
        this.executorService = executorService;
        this.searchEngine = searchEngine;
        this.updateIndexesAsynchronously = this.executorService != null && updateIndexesAsynchronously;
        this.executeAsynchronously = this.executorService != null && executeAsynchronously;
    }

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine) {
        this(wrapped, searchEngine, null, false, false);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void close() {
        this.delegate.close();
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new RepositorySourceCapabilities(this.delegate.getCapabilities()){

            public boolean supportsQueries() {
                return true;
            }

            public boolean supportsSearches() {
                return true;
            }
        };
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.executeRequestsAsynchronously()) {
            assert (this.executorService != null);
            return new ParallelConnection(this.executorService);
        }
        return new SynchronousConnection();
    }

    public int getRetryLimit() {
        return this.delegate.getRetryLimit();
    }

    public void initialize(final RepositoryContext context) throws RepositorySourceException {
        final String delegateSourceName = this.delegate.getName();
        final RepositoryConnectionFactory originalConnectionFactory = context.getRepositoryConnectionFactory();
        final RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (delegateSourceName.equals(sourceName)) {
                    return SearchableRepositorySource.this.delegate().getConnection();
                }
                return originalConnectionFactory.createConnection(sourceName);
            }
        };
        final Observer observer = new Observer(){

            public void notify(final Changes changes) {
                if (changes != null) {
                    if (SearchableRepositorySource.this.updateIndexesAsynchronously()) {
                        SearchableRepositorySource.this.executorService().submit(new Runnable(){

                            public void run() {
                                SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                            }
                        });
                    } else {
                        SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                    }
                }
            }
        };
        RepositoryContext newContext = new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return context.getConfiguration(depth);
            }

            public ExecutionContext getExecutionContext() {
                return context.getExecutionContext();
            }

            public Observer getObserver() {
                return observer;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return connectionFactory;
            }
        };
        this.delegate.initialize(newContext);
    }

    protected final SearchEngine searchEngine() {
        assert (this.searchEngine != null);
        return this.searchEngine;
    }

    protected final boolean updateIndexesAsynchronously() {
        return this.executorService != null && this.updateIndexesAsynchronously;
    }

    protected final boolean executeRequestsAsynchronously() {
        return this.executorService != null && this.executeAsynchronously;
    }

    protected final ExecutorService executorService() {
        assert (this.executorService != null);
        return this.executorService;
    }

    protected final RepositorySource delegate() {
        return this.delegate;
    }

    protected void process(ExecutionContext context, Changes changes) {
        assert (context != null);
        assert (changes != null);
        if (this.searchEngine == null) {
            return;
        }
        this.searchEngine.index(context, changes.getChangeRequests());
    }

    public void setRetryLimit(int limit) {
        this.delegate.setRetryLimit(limit);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    @NotThreadSafe
    protected class SynchronousConnection
    extends AbstractConnection {
        protected SynchronousConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            SearchEngineProcessor searchProcessor = null;
            switch (request.getType()) {
                case ACCESS_QUERY: {
                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(queryRequest);
                        Object var6_6 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case FULL_TEXT_SEARCH: {
                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(searchRequest);
                        Object var8_12 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case COMPOSITE: {
                    CompositeRequest composite = (CompositeRequest)request;
                    LinkedList<Request> delegateRequests = null;
                    try {
                        Request delegateRequest = composite;
                        block15: for (Request nested : composite) {
                            switch (nested.getType()) {
                                case ACCESS_QUERY: {
                                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(queryRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                                case FULL_TEXT_SEARCH: {
                                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(searchRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                            }
                            if (delegateRequests == null) {
                                delegateRequests = new LinkedList<Request>();
                            }
                            delegateRequests.add(request);
                        }
                        if (delegateRequest == null) {
                            if (delegateRequests != null) {
                                assert (!delegateRequests.isEmpty());
                                delegateRequest = CompositeRequest.with((List<? extends Request>)delegateRequests);
                                this.delegateConnection().execute(context, delegateRequest);
                            }
                        } else {
                            this.delegateConnection().execute(context, request);
                        }
                        Object var12_19 = null;
                        if (searchProcessor == null) break;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (searchProcessor != null) {
                            ((RequestProcessor)searchProcessor).close();
                        }
                        throw throwable;
                    }
                }
                default: {
                    this.delegateConnection().execute(context, request);
                }
            }
        }
    }

    @NotThreadSafe
    protected class ParallelConnection
    extends AbstractConnection {
        private final ExecutorService executorService;

        protected ParallelConnection(ExecutorService executorService) {
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            SearchEngineProcessor searchProcessor = null;
            switch (request.getType()) {
                case ACCESS_QUERY: {
                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(queryRequest);
                        return;
                    }
                    finally {
                        ((RequestProcessor)searchProcessor).close();
                    }
                }
                case FULL_TEXT_SEARCH: {
                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(searchRequest);
                        return;
                    }
                    finally {
                        ((RequestProcessor)searchProcessor).close();
                    }
                }
                case COMPOSITE: {
                    Object v1;
                    CompositeRequest composite = (CompositeRequest)request;
                    CompositeRequestChannel channel = null;
                    try {
                        block36: for (Request nested : composite) {
                            switch (nested.getType()) {
                                case ACCESS_QUERY: {
                                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(queryRequest);
                                    continue block36;
                                }
                                case FULL_TEXT_SEARCH: {
                                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(searchRequest);
                                    continue block36;
                                }
                            }
                            if (channel == null) {
                                RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

                                    public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                                        assert (SearchableRepositorySource.this.delegate().getName().equals(sourceName));
                                        return ParallelConnection.this.delegateConnection();
                                    }
                                };
                                channel = new CompositeRequestChannel(SearchableRepositorySource.this.delegate().getName());
                                channel.start(this.executorService, context, connectionFactory);
                            }
                            channel.add(request);
                        }
                        Object var12_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object v0;
                        Object var12_16 = null;
                        try {
                            if (searchProcessor != null) {
                                ((RequestProcessor)searchProcessor).close();
                            }
                            v0 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var14_20;
                            v0 = var14_20 = null;
                        }
                        if (channel == null) throw throwable;
                        try {
                            channel.close();
                            Object var16_23 = null;
                        }
                        catch (Throwable throwable3) {
                            Object var16_24 = null;
                            try {
                                channel.await();
                                throw throwable3;
                            }
                            catch (CancellationException err) {
                                composite.cancel();
                                throw throwable3;
                            }
                            catch (ExecutionException err) {
                                composite.setError(err);
                                throw throwable3;
                            }
                            catch (InterruptedException err) {
                                Thread.interrupted();
                                I18n msg = GraphI18n.interruptedWhileClosingChannel;
                                Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                                composite.setError(err);
                            }
                            throw throwable3;
                        }
                        try {
                            channel.await();
                            throw throwable;
                        }
                        catch (CancellationException err) {
                            composite.cancel();
                            throw throwable;
                        }
                        catch (ExecutionException err) {
                            composite.setError(err);
                            throw throwable;
                        }
                        catch (InterruptedException err) {
                            Thread.interrupted();
                            I18n msg = GraphI18n.interruptedWhileClosingChannel;
                            Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                            composite.setError(err);
                        }
                        throw throwable;
                    }
                    try {
                        if (searchProcessor != null) {
                            ((RequestProcessor)searchProcessor).close();
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_19;
                        v1 = var14_19 = null;
                    }
                    if (channel == null) return;
                    try {
                        channel.close();
                        Object var16_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_22 = null;
                        try {
                            channel.await();
                            throw throwable;
                        }
                        catch (CancellationException err) {
                            composite.cancel();
                            throw throwable;
                        }
                        catch (ExecutionException err) {
                            composite.setError(err);
                            throw throwable;
                        }
                        catch (InterruptedException err) {
                            Thread.interrupted();
                            I18n msg = GraphI18n.interruptedWhileClosingChannel;
                            Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                            composite.setError(err);
                        }
                        throw throwable;
                    }
                    try {
                        channel.await();
                        return;
                    }
                    catch (CancellationException err) {
                        composite.cancel();
                        return;
                    }
                    catch (ExecutionException err) {
                        composite.setError(err);
                        return;
                    }
                    catch (InterruptedException err) {
                        Thread.interrupted();
                        I18n msg = GraphI18n.interruptedWhileClosingChannel;
                        Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                        composite.setError(err);
                    }
                    return;
                }
                default: {
                    this.delegateConnection().execute(context, request);
                }
            }
        }
    }

    @NotThreadSafe
    protected abstract class AbstractConnection
    implements RepositoryConnection {
        private RepositoryConnection delegateConnection;

        protected AbstractConnection() {
        }

        protected RepositoryConnection delegateConnection() {
            if (this.delegateConnection == null) {
                this.delegateConnection = SearchableRepositorySource.this.delegate().getConnection();
            }
            return this.delegateConnection;
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            return this.delegateConnection().ping(time, unit);
        }

        public CachePolicy getDefaultCachePolicy() {
            return this.delegateConnection().getDefaultCachePolicy();
        }

        public String getSourceName() {
            return SearchableRepositorySource.this.delegate().getName();
        }

        public XAResource getXAResource() {
            return this.delegateConnection().getXAResource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.delegateConnection != null) {
                try {
                    this.delegateConnection.close();
                }
                finally {
                    this.delegateConnection = null;
                }
            }
        }
    }
}

