/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRequestChannel {
    private static final Logger LOGGER = Logger.getLogger(CompositeRequestChannel.class);
    protected final String sourceName;
    protected final LinkedList<Request> allRequests = new LinkedList();
    private final BlockingQueue<Request> queue = new LinkedBlockingQueue<Request>();
    protected final CompositeRequest composite;
    protected Future<String> future;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected Throwable compositeError = null;
    private final boolean keepRequests;

    public CompositeRequestChannel(String sourceName) {
        assert (sourceName != null);
        this.sourceName = sourceName;
        this.composite = new ChannelCompositeRequest();
        this.keepRequests = true;
    }

    public CompositeRequestChannel(String sourceName, boolean keepRequests) {
        assert (sourceName != null);
        this.sourceName = sourceName;
        this.composite = new ChannelCompositeRequest();
        this.keepRequests = keepRequests;
    }

    protected Iterator<Request> createIterator() {
        final BlockingQueue<Request> queue = this.queue;
        return new Iterator<Request>(){
            private Request next;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    this.next = (Request)queue.take();
                }
                catch (InterruptedException e) {
                    try {
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
                if (RequestType.LAST == this.next.getType()) {
                    return false;
                }
                return this.next != null;
            }

            @Override
            public Request next() {
                if (this.next == null) {
                    try {
                        this.next = (Request)queue.take();
                    }
                    catch (InterruptedException e) {
                        try {
                            throw new NoSuchElementException();
                        }
                        catch (Throwable throwable) {
                            Thread.interrupted();
                            throw throwable;
                        }
                    }
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Request result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void start(ExecutorService executor, final ExecutionContext context, final RepositoryConnectionFactory connectionFactory) {
        assert (executor != null);
        assert (context != null);
        assert (connectionFactory != null);
        assert (this.sourceName != null);
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.future = executor.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                try {
                    RepositoryConnection connection = connectionFactory.createConnection(CompositeRequestChannel.this.sourceName);
                    assert (connection != null);
                    try {
                        connection.execute(context, CompositeRequestChannel.this.composite);
                    }
                    finally {
                        connection.close();
                    }
                }
                catch (Throwable t) {
                    CompositeRequestChannel.this.cancelAllRequestsDueToError(t);
                }
                return CompositeRequestChannel.this.sourceName;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllRequestsDueToError(Throwable t) {
        LOGGER.error(t, GraphI18n.executingRequest, this.sourceName);
        try {
            for (Request request : this.composite.getRequests()) {
                try {
                    request.cancel();
                }
                finally {
                    request.freeze();
                }
            }
            this.cancel(true);
        }
        finally {
            this.composite.freeze();
        }
    }

    public void start(ExecutorService executor, final RequestProcessor processor, final boolean closeProcessorWhenCompleted) {
        assert (executor != null);
        assert (processor != null);
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.future = executor.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                try {
                    processor.process(CompositeRequestChannel.this.composite);
                }
                catch (Throwable t) {
                    CompositeRequestChannel.this.cancelAllRequestsDueToError(t);
                }
                finally {
                    if (closeProcessorWhenCompleted) {
                        processor.close();
                    }
                }
                return CompositeRequestChannel.this.sourceName;
            }
        });
    }

    public void add(Request request) {
        if (this.closed.get()) {
            throw new IllegalStateException(GraphI18n.unableToAddRequestToChannelThatIsDone.text(this.sourceName, request));
        }
        assert (request != null);
        if (this.keepRequests) {
            this.allRequests.add(request);
        }
        this.queue.add(request);
    }

    public CountDownLatch add(Request request, CountDownLatch latch) {
        if (this.closed.get()) {
            throw new IllegalStateException(GraphI18n.unableToAddRequestToChannelThatIsDone.text(this.sourceName, request));
        }
        assert (request != null);
        assert (latch != null);
        if (this.keepRequests) {
            this.allRequests.add(request);
        }
        request.setLatchForFreezing(latch);
        this.queue.add(request);
        return latch;
    }

    public void addAndAwait(Request request) throws InterruptedException {
        this.add(request, new CountDownLatch(1)).await();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.queue.add(new LastRequest());
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void cancel(boolean mayInterruptIfRunning) {
        if (this.future == null || this.future.isDone() || this.future.isCancelled()) {
            return;
        }
        this.composite.cancel();
        this.close();
        this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isStarted() {
        return this.future != null;
    }

    public boolean isComplete() {
        return this.future != null && this.future.isDone();
    }

    public void await() throws ExecutionException, InterruptedException, CancellationException {
        this.future.get();
    }

    public List<Request> allRequests() {
        return this.allRequests;
    }

    public String sourceName() {
        return this.sourceName;
    }

    protected static class LastRequest
    extends Request {
        private static final long serialVersionUID = 1L;

        protected LastRequest() {
        }

        public boolean isReadOnly() {
            return false;
        }

        public RequestType getType() {
            return RequestType.LAST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChannelCompositeRequest
    extends CompositeRequest {
        private static final long serialVersionUID = 1L;
        private final LinkedList<Request> allRequests;

        protected ChannelCompositeRequest() {
            super(false);
            this.allRequests = CompositeRequestChannel.this.allRequests;
        }

        @Override
        public Iterator<Request> iterator() {
            return CompositeRequestChannel.this.createIterator();
        }

        @Override
        public List<Request> getRequests() {
            return this.allRequests;
        }

        @Override
        public int size() {
            return CompositeRequestChannel.this.closed.get() ? this.allRequests.size() : Integer.MAX_VALUE;
        }

        @Override
        public void cancel() {
            CompositeRequestChannel.this.closed.set(true);
        }

        @Override
        public void setError(Throwable error) {
            CompositeRequestChannel.this.compositeError = error;
            super.setError(error);
        }

        @Override
        public boolean hasError() {
            return CompositeRequestChannel.this.compositeError != null || super.hasError();
        }
    }
}

