/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.basic.BasicProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BasicMultiValueProperty
extends BasicProperty {
    private static final long serialVersionUID = 1L;
    private final List<Object> values;

    public BasicMultiValueProperty(Name name, List<Object> values) {
        super(name);
        CheckArg.isNotNull(values, "values");
        CheckArg.hasSizeOfAtLeast(values, 2, "values");
        this.values = values;
    }

    public BasicMultiValueProperty(Name name, Object ... values) {
        super(name);
        CheckArg.isNotNull(values, "values");
        CheckArg.hasSizeOfAtLeast(values, 2, "values");
        this.values = Arrays.asList(values);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isMultiple() {
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Object getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ReadOnlyIterator(this.values.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReadOnlyIterator
    implements Iterator<Object> {
        private final Iterator<Object> values;

        protected ReadOnlyIterator(Iterator<Object> values) {
            assert (values != null);
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.values.hasNext();
        }

        @Override
        public Object next() {
            return this.values.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

