/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

public class ProjectionPathRuleTest {
    private ExecutionContext context;
    private Projection.PathRule rule;
    private PathFactory pathFactory;
    private Path repositoryPath;
    private Path sourcePath;
    private Path[] validExceptions;
    private NamespaceRegistry registry;
    private TextEncoder encoder;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.registry = this.context.getNamespaceRegistry();
        this.encoder = new UrlEncoder();
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/x/y");
        this.validExceptions = new Path[]{(Path)this.pathFactory.create("e/f"), (Path)this.pathFactory.create("e/g")};
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
    }

    @Test
    public void shouldCreateInstanceWithValidRepositoryPathAndValidSourcePathAndNoExceptions() {
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath);
        Assert.assertThat((Object)this.rule.getPathInRepository(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.repositoryPath)));
        Assert.assertThat((Object)this.rule.getPathInSource(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.sourcePath)));
        Assert.assertThat((Object)this.rule.hasExceptionsToRule(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateInstanceWithValidRepositoryPathAndValidSourcePathAndValidExceptions() {
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getPathInRepository(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.repositoryPath)));
        Assert.assertThat((Object)this.rule.getPathInSource(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.sourcePath)));
        Assert.assertThat((Object)this.rule.hasExceptionsToRule(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rule.getExceptionsToRule(), (Matcher)JUnitMatchers.hasItems((Object[])this.validExceptions));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithNullRepositoryPathAndValidSourcePathAndNoExceptions() {
        this.repositoryPath = null;
        new Projection.PathRule(this.repositoryPath, this.sourcePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidRepositoryPathAndNullSourcePathAndNoExceptions() {
        this.sourcePath = null;
        new Projection.PathRule(this.repositoryPath, this.sourcePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidRepositoryPathAndValidSourcePathAndAbsoluteExceptions() {
        Path relativePath = this.validExceptions[0];
        Path absolutePath = (Path)this.pathFactory.create("/j/k/l/m");
        new Projection.PathRule(this.repositoryPath, this.sourcePath, new Path[]{relativePath, absolutePath});
    }

    @Test
    public void shouldIncludeRepositoryPathsAtPathInRepository() {
        Assert.assertThat((Object)this.rule.includes(this.sourcePath), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldIncludeRepositoryPathsBelowPathInRepositoryThatAreNotExcluded() {
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "m")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "m/n")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "o/p")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/e")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotIncludeRepositoryPathsBelowPathInRepositoryThatAreExcluded() {
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/f")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/g")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/f/g")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/g/h")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotIncludeRepositoryPathsNotBelowPathInRepository() {
        Assert.assertThat((Object)this.rule.includes((Path)this.pathFactory.create("/m/n")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.rule.includes((Path)this.pathFactory.create("/x/y[3]")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProjectRepositoryPathIntoSourcePath() {
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(this.repositoryPath, this.pathFactory), (Matcher)Is.is((Object)this.sourcePath));
    }

    @Test
    public void shouldProjectPathBelowRepositoryPathIntoPathBelowSourcePath() {
        Path pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n");
        Path pathInSource = this.pathFactory.create(this.sourcePath, "m/n");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), (Matcher)Is.is((Object)pathInSource));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m");
        pathInSource = this.pathFactory.create(this.sourcePath, "m");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), (Matcher)Is.is((Object)pathInSource));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n[3]");
        pathInSource = this.pathFactory.create(this.sourcePath, "m/n[3]");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), (Matcher)Is.is((Object)pathInSource));
    }

    @Test
    public void shouldProjectSourcePathIntoRepositoryPath() {
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(this.sourcePath, this.pathFactory), (Matcher)Is.is((Object)this.repositoryPath));
    }

    @Test
    public void shouldProjectPathBelowSourcePathIntoPathBelowRepositoryPath() {
        Path pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n");
        Path pathInSource = this.pathFactory.create(this.sourcePath, "m/n");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), (Matcher)Is.is((Object)pathInRepository));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m");
        pathInSource = this.pathFactory.create(this.sourcePath, "m");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), (Matcher)Is.is((Object)pathInRepository));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n[3]");
        pathInSource = this.pathFactory.create(this.sourcePath, "m/n[3]");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), (Matcher)Is.is((Object)pathInRepository));
    }

    @Test
    public void shouldGetPathsInRepositoryGivenPathsInSourceAtOrBelowSourcePathIfNotExcluded() {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.sourcePath, this.pathFactory), (Matcher)Is.is((Object)this.repositoryPath));
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m/n");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m[1]");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m[1]/n/o/p");
    }

    protected void assertThatGetPathInRepositoryReturnsCorrectPathInSource(String subpath) {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, subpath), this.pathFactory), (Matcher)Is.is((Object)this.pathFactory.create(this.repositoryPath, subpath)));
    }

    @Test
    public void shouldGetNullPathInRepositoryGivenPathsInSourceAtOrBelowSourcePathIfExcluded() {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/f"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/g"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/f/h"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/g/h"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldGetNullPathInRepositoryGivenPathsInRepositoryNotAtOrBelowSourcePath() {
        Assert.assertThat((Object)this.rule.getPathInRepository((Path)this.pathFactory.create("/m/n"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldGetPathsInSourceGivenPathsInRepositoryAtOrBelowRepositoryPathIfNotExcluded() {
        Assert.assertThat((Object)this.rule.getPathInSource(this.repositoryPath, this.pathFactory), (Matcher)Is.is((Object)this.sourcePath));
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m/n");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m[1]");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m[1]/n/o/p");
    }

    protected void assertThatGetPathInSourceReturnsCorrectPathInRepository(String subpath) {
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, subpath), this.pathFactory), (Matcher)Is.is((Object)this.pathFactory.create(this.sourcePath, subpath)));
    }

    @Test
    public void shouldGetNullPathInSourceGivenPathsInRepositoryAtOrBelowRepositoryPathIfExcluded() {
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/f"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/g"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/f/h"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/g/h"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldGetNullPathInSourceGivenPathsInRepositoryNotAtOrBelowRepositoryPath() {
        Assert.assertThat((Object)this.rule.getPathInSource((Path)this.pathFactory.create("/m/n"), this.pathFactory), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConvertToString() {
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), (Matcher)Is.is((Object)"/a/b/c => /x/y $ e/f $ e/g"));
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), (Matcher)Is.is((Object)"/a/b/c => / $ e/f $ e/g"));
        this.repositoryPath = (Path)this.pathFactory.create("/");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), (Matcher)Is.is((Object)"/ => / $ e/f $ e/g"));
    }

    @Test
    public void shouldHaveToString() {
        Assert.assertThat((Object)this.rule.toString(), (Matcher)Is.is((Object)"/{}a/{}b/{}c => /{}x/{}y $ {}e/{}f $ {}e/{}g"));
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.toString(), (Matcher)Is.is((Object)"/{}a/{}b/{}c => / $ {}e/{}f $ {}e/{}g"));
    }
}

