/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StandardValueFactories;
import org.modeshape.graph.property.basic.SystemPropertyFactory;

public class SystemPropertyFactoryTest {
    private static final String TESTPROP = "test.prop";
    private static final String TESTPROPVALUE = "test.prop.value";
    private static final String TESTPROP2 = "test.prop2";
    private static final String TESTPROPVALUE2 = "test.prop.value2";
    private NamespaceRegistry registry;
    private SystemPropertyFactory systemPropertyFactory;

    @Before
    public void setUp() throws Exception {
        this.registry = new SimpleNamespaceRegistry();
        this.systemPropertyFactory = new SystemPropertyFactory((ValueFactories)new StandardValueFactories(this.registry));
        System.setProperty(TESTPROP, TESTPROPVALUE);
        System.setProperty(TESTPROP2, TESTPROPVALUE2);
    }

    @Test
    public void shouldSubstituteSingleVariable() {
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${test.prop}"), (Matcher)Is.is((Object)TESTPROPVALUE));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${test.prop}"), (Matcher)Is.is((Object)"find.the.property.test.prop.value"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${test.prop}.find.the.property"), (Matcher)Is.is((Object)"test.prop.value.find.the.property"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${test.prop}.find.the.property"), (Matcher)Is.is((Object)"find.the.property.test.prop.value.find.the.property"));
    }

    @Test
    public void shouldSubstituteFirstFoundMultipleVariables() {
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop,test.prop}"), (Matcher)Is.is((Object)TESTPROPVALUE));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${any.prop,test.prop}"), (Matcher)Is.is((Object)"find.the.property.test.prop.value"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop,test.prop}.find.the.property"), (Matcher)Is.is((Object)"test.prop.value.find.the.property"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${any.prop,test.prop}.find.the.property"), (Matcher)Is.is((Object)"find.the.property.test.prop.value.find.the.property"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop,test.prop,test.prop2}.find.the.property"), (Matcher)Is.is((Object)"test.prop.value.find.the.property"));
    }

    @Test
    public void shouldSubstituteMultipleVariablesWithDefault() {
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop1,any.prop2:test.prop.value}"), (Matcher)Is.is((Object)TESTPROPVALUE));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${any.prop1:test.prop.value}"), (Matcher)Is.is((Object)"find.the.property.test.prop.value"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop1,any.prop2:test.prop.value}.find.the.property"), (Matcher)Is.is((Object)"test.prop.value.find.the.property"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("find.the.property.${any.prop:test.prop.value}.find.the.property"), (Matcher)Is.is((Object)"find.the.property.test.prop.value.find.the.property"));
    }

    @Test
    public void shouldSubstituteMultipleVariableGroups() {
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${test.prop}.double.${test.prop}"), (Matcher)Is.is((Object)"test.prop.value.double.test.prop.value"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop,test.prop}.double.${any.prop,test.prop}"), (Matcher)Is.is((Object)"test.prop.value.double.test.prop.value"));
        Assert.assertThat((Object)this.systemPropertyFactory.getSubstitutedProperty("${any.prop:test.prop.value}.double.${any.prop:test.prop.value}"), (Matcher)Is.is((Object)"test.prop.value.double.test.prop.value"));
    }
}

