/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.util.CheckArg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArithmeticOperator {
    ADD("+", Arity.BINARY, 20),
    SUBTRACT("-", Arity.BINARY, 19),
    MULTIPLY("*", Arity.BINARY, 18),
    DIVIDE("/", Arity.BINARY, 17);

    private static final Map<String, ArithmeticOperator> OPERATORS_BY_SYMBOL;
    private final String symbol;
    private final Arity arity;
    private final int precedence;

    private ArithmeticOperator(String symbol, Arity arity, int precedence) {
        this.symbol = symbol;
        this.arity = arity;
        this.precedence = precedence;
    }

    public String symbol() {
        return this.symbol;
    }

    public Arity arity() {
        return this.arity;
    }

    public boolean isUnary() {
        return this.arity == Arity.UNARY;
    }

    public boolean isBinary() {
        return this.arity == Arity.BINARY;
    }

    public boolean precedes(ArithmeticOperator operator) {
        return this.precedence > operator.precedence;
    }

    public String toString() {
        return this.symbol;
    }

    public static ArithmeticOperator forSymbol(String symbol) {
        CheckArg.isNotNull(symbol, "symbol");
        return OPERATORS_BY_SYMBOL.get(symbol.toUpperCase());
    }

    static {
        HashMap<String, ArithmeticOperator> opsBySymbol = new HashMap<String, ArithmeticOperator>();
        for (ArithmeticOperator operator : ArithmeticOperator.values()) {
            opsBySymbol.put(operator.symbol(), operator);
        }
        OPERATORS_BY_SYMBOL = Collections.unmodifiableMap(opsBySymbol);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arity {
        UNARY,
        BINARY;

    }
}

