/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.List;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleRequestFailuresException
extends RequestException {
    private static final long serialVersionUID = 1L;
    private final List<Request> failedRequests;
    private final int totalNumberOfRequests;
    private transient String msg = null;

    public MultipleRequestFailuresException(List<Request> failedRequests, int totalNumberOfRequests) {
        this.failedRequests = Collections.unmodifiableList(failedRequests);
        this.totalNumberOfRequests = totalNumberOfRequests;
        assert (this.failedRequests != null);
        assert (this.totalNumberOfRequests > 0);
    }

    public int getTotalNumberOfRequests() {
        return this.totalNumberOfRequests;
    }

    public List<Request> getFailedRequests() {
        return this.failedRequests;
    }

    @Override
    public String getMessage() {
        if (this.msg == null) {
            StringBuilder str = new StringBuilder();
            for (Request requestWithError : this.failedRequests) {
                str.append("\n");
                str.append("\t" + requestWithError + " --> " + requestWithError.getError().getMessage());
            }
            int numberOfErrors = this.failedRequests.size();
            this.msg = this.totalNumberOfRequests == Integer.MAX_VALUE ? GraphI18n.multipleErrorsWhileExecutingManyRequests.text(new Object[]{numberOfErrors, str.toString()}) : GraphI18n.multipleErrorsWhileExecutingRequests.text(new Object[]{numberOfErrors, this.totalNumberOfRequests, str.toString()});
        }
        return this.msg;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

