/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicNamespace;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class GraphNamespaceRegistry
implements NamespaceRegistry {
    public static final Name DEFAULT_URI_PROPERTY_NAME = ModeShapeLexicon.URI;
    public static final Name DEFAULT_GENERATED_PROPERTY_NAME = ModeShapeLexicon.GENERATED;
    public static final String GENERATED_PREFIX = "ns";
    protected static final Pattern GENERATED_PREFIX_PATTERN = Pattern.compile("ns(\\d{3})");
    private SimpleNamespaceRegistry cache = new SimpleNamespaceRegistry();
    private final Graph store;
    private final Path parentOfNamespaceNodes;
    private final Name uriPropertyName;
    private final Name generatedPropertyName;
    private final List<Property> namespaceProperties;

    public GraphNamespaceRegistry(Graph store, Path parentOfNamespaceNodes, Name uriPropertyName, Name generatedPropertyName, Property ... additionalProperties) {
        this.store = store;
        this.parentOfNamespaceNodes = parentOfNamespaceNodes;
        this.uriPropertyName = uriPropertyName != null ? uriPropertyName : DEFAULT_URI_PROPERTY_NAME;
        this.generatedPropertyName = generatedPropertyName != null ? generatedPropertyName : DEFAULT_GENERATED_PROPERTY_NAME;
        List properties = Collections.emptyList();
        if (additionalProperties != null && additionalProperties.length != 0) {
            properties = new ArrayList(additionalProperties.length);
            HashSet propertyNames = new HashSet();
            for (Property property : additionalProperties) {
                if (propertyNames.contains(property.getName())) continue;
                properties.add(property);
            }
        }
        this.namespaceProperties = Collections.unmodifiableList(properties);
        this.createNamespaceParentIfNeeded();
        this.initializeCacheFromStore(this.cache);
    }

    private void createNamespaceParentIfNeeded() {
        this.store.create(this.parentOfNamespaceNodes).ifAbsent().and(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.NAMESPACES).and();
    }

    public Path getParentOfNamespaceNodes() {
        return this.parentOfNamespaceNodes;
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull(prefix, "prefix");
        String uri = this.cache.getNamespaceForPrefix(prefix);
        if (uri == null && (uri = this.readUriFor(prefix)) != null) {
            this.cache.register(prefix, uri);
        }
        return uri;
    }

    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull(namespaceUri, "namespaceUri");
        String prefix = this.cache.getPrefixForNamespaceUri(namespaceUri, false);
        if (prefix == null && generateIfMissing && (prefix = this.readPrefixFor(namespaceUri, generateIfMissing)) != null) {
            this.cache.register(prefix, namespaceUri);
        }
        return prefix;
    }

    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull(namespaceUri, "namespaceUri");
        if (this.cache.isRegisteredNamespaceUri(namespaceUri)) {
            return true;
        }
        String prefix = this.readPrefixFor(namespaceUri, false);
        if (prefix != null) {
            this.cache.register(prefix, namespaceUri);
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.getNamespaceForPrefix("");
    }

    @Override
    public void register(Iterable<NamespaceRegistry.Namespace> namespaces) {
        HashMap<String, String> urisByPrefix = new HashMap<String, String>();
        for (NamespaceRegistry.Namespace namespace : namespaces) {
            urisByPrefix.put(namespace.getPrefix(), namespace.getNamespaceUri());
        }
        this.register(urisByPrefix);
    }

    public void register(Map<String, String> namespaceUrisByPrefix) {
        if (namespaceUrisByPrefix == null || namespaceUrisByPrefix.isEmpty()) {
            return;
        }
        this.doRegister(namespaceUrisByPrefix);
        for (Map.Entry<String, String> entry : namespaceUrisByPrefix.entrySet()) {
            String prefix = entry.getKey().trim();
            String uri = entry.getValue().trim();
            if (prefix.length() == 0) continue;
            this.cache.register(prefix, uri);
        }
    }

    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull(namespaceUri, "namespaceUri");
        namespaceUri = namespaceUri.trim();
        String previousCachedUriForPrefix = this.cache.register(prefix, namespaceUri);
        if (!namespaceUri.equals(previousCachedUriForPrefix)) {
            return this.doRegister(Collections.singletonMap(prefix, namespaceUri)).get(prefix);
        }
        return previousCachedUriForPrefix;
    }

    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull(namespaceUri, "namespaceUri");
        namespaceUri = namespaceUri.trim();
        boolean found = this.cache.unregister(namespaceUri);
        return this.doUnregister(namespaceUri) || found;
    }

    @Override
    public Set<String> getRegisteredNamespaceUris() {
        return this.cache.getRegisteredNamespaceUris();
    }

    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        return this.cache.getNamespaces();
    }

    public void refresh() {
        SimpleNamespaceRegistry newCache = new SimpleNamespaceRegistry();
        this.initializeCacheFromStore(newCache);
        this.cache = newCache;
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }

    protected void initializeCacheFromStore(NamespaceRegistry cache) {
        HashSet<NamespaceRegistry.Namespace> toRegister = new HashSet<NamespaceRegistry.Namespace>(this.store.getContext().getNamespaceRegistry().getNamespaces());
        try {
            String prefix;
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String uri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (uri == null) continue;
                prefix = this.getPrefixFor(nsLocation.getPath());
                cache.register(prefix, uri);
                toRegister.remove(new BasicNamespace(prefix, uri));
            }
            cache.register("", "");
            toRegister.remove(cache.getNamespaceForPrefix(""));
            if (!toRegister.isEmpty()) {
                Graph.Batch batch = this.store.batch();
                PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
                for (NamespaceRegistry.Namespace namespace : toRegister) {
                    prefix = namespace.getPrefix();
                    if (prefix.length() == 0) continue;
                    String uri = namespace.getNamespaceUri();
                    Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
                    batch.create(pathToNamespaceNode).with(this.namespaceProperties).and(this.uriPropertyName, uri).and();
                    cache.register(prefix, uri);
                }
                batch.execute();
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected String readUriFor(String prefix) {
        try {
            PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
            Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
            Property uri = (Property)this.store.getProperty(this.uriPropertyName).on(pathToNamespaceNode);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            return stringFactory.create(uri.getFirstValue());
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    protected String getPrefixFor(Path path) {
        Path.Segment lastSegment = path.getLastSegment();
        String localName = lastSegment.getName().getLocalName();
        int index = lastSegment.getIndex();
        return this.getPrefixFor(localName, index);
    }

    protected String getPrefixFor(String name, int counter) {
        if (counter == 1 && !GENERATED_PREFIX.equals(name)) {
            return name;
        }
        if (counter < 10) {
            return name + "00" + counter;
        }
        if (counter < 100) {
            return name + "0" + counter;
        }
        assert (counter < 1000);
        return name + counter;
    }

    protected boolean isGeneratedPrefix(String prefix) {
        return GENERATED_PREFIX_PATTERN.matcher(prefix).matches();
    }

    protected String generatePrefix(Set<String> existingGeneratedPrefixes) {
        int maxCounter = 0;
        if (existingGeneratedPrefixes != null) {
            for (String prefix : existingGeneratedPrefixes) {
                Matcher matcher;
                if (prefix == null || !(matcher = GENERATED_PREFIX_PATTERN.matcher(prefix)).matches()) continue;
                int value = Integer.parseInt(matcher.group(1));
                maxCounter = Math.max(maxCounter, value);
            }
        }
        return this.getPrefixFor(GENERATED_PREFIX, ++maxCounter);
    }

    protected String readPrefixFor(String namespaceUri, boolean generateIfMissing) {
        try {
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
            ValueFactory<Boolean> booleanFactory = this.store.getContext().getValueFactories().getBooleanFactory();
            HashSet<String> generatedPrefixes = null;
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String prefix = this.getPrefixFor(nsLocation.getPath());
                String uri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (prefix != null && uri != null && uri.equals(namespaceUri)) {
                    return prefix;
                }
                Property generatedProperty = ns.getProperty(this.generatedPropertyName);
                boolean generated = generatedProperty == null ? this.isGeneratedPrefix(prefix) : booleanFactory.create(generatedProperty.getFirstValue()).booleanValue();
                if (!generated) continue;
                if (generatedPrefixes == null) {
                    generatedPrefixes = new HashSet<String>();
                }
                generatedPrefixes.add(prefix);
            }
            if (generateIfMissing) {
                PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
                String prefix = this.generatePrefix(generatedPrefixes);
                Path pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, prefix);
                Property uriProperty = this.store.getContext().getPropertyFactory().create(this.uriPropertyName, namespaceUri);
                Property genProperty = this.store.getContext().getPropertyFactory().create(this.generatedPropertyName, true);
                ArrayList<Property> props = new ArrayList<Property>(this.namespaceProperties);
                props.add(uriProperty);
                props.add(genProperty);
                this.store.create(pathToNamespaceNode, props).ifAbsent().and();
                return this.getPrefixFor(pathToNamespaceNode);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected Map<String, String> doRegister(Map<String, String> newUrisByPrefix) {
        HashMap<String, String> previousUrisByNewPrefixes = new HashMap<String, String>();
        HashMap<String, String> existingUrisByPrefix = new HashMap<String, String>();
        HashMap<String, String> existingPrefixesByUri = new HashMap<String, String>();
        ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
        PathFactory pathFactory = this.store.getContext().getValueFactories().getPathFactory();
        Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
        Graph.Batch batch = this.store.batch();
        HashMap<String, Path> existingPathsByPrefix = new HashMap<String, Path>();
        for (Location location : nsGraph.getRoot().getChildren()) {
            Object ns = nsGraph.getNode(location);
            Path path = location.getPath();
            String actualPrefix = this.getPrefixFor(path);
            String actualUri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
            if (actualPrefix == null || actualUri == null) continue;
            existingUrisByPrefix.put(actualPrefix, actualUri);
            existingPrefixesByUri.put(actualUri, actualPrefix);
            existingPathsByPrefix.put(actualPrefix, path);
        }
        for (Map.Entry entry : newUrisByPrefix.entrySet()) {
            Path pathToNamespaceNode;
            String newPrefix = ((String)entry.getKey()).trim();
            String newUri = ((String)entry.getValue()).trim();
            if (newPrefix.length() == 0) continue;
            String existingUriForNewPrefix = (String)existingUrisByPrefix.get(newPrefix);
            String existingPrefixForNewUri = (String)existingPrefixesByUri.get(newUri);
            if (existingUriForNewPrefix == null) {
                pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, newPrefix);
                batch.create(pathToNamespaceNode).orReplace().with(this.namespaceProperties).and(this.uriPropertyName, newUri).and();
                if (existingPrefixForNewUri == null || existingPrefixForNewUri.equals(newPrefix)) continue;
                Path pathToOldNamespaceNode = (Path)existingPathsByPrefix.get(existingPrefixForNewUri);
                batch.delete(pathToOldNamespaceNode).and();
                continue;
            }
            if (newUri.equals(existingUriForNewPrefix)) continue;
            pathToNamespaceNode = pathFactory.create(this.parentOfNamespaceNodes, newPrefix);
            previousUrisByNewPrefixes.put(newPrefix, existingUriForNewPrefix);
            ((Graph.BatchConjunction)((Graph.On)batch.set(this.uriPropertyName).to(newUri)).on(pathToNamespaceNode)).and();
        }
        batch.execute();
        return previousUrisByNewPrefixes;
    }

    protected boolean doUnregister(String uri) {
        ValueFactory<String> stringFactory = this.store.getContext().getValueFactories().getStringFactory();
        boolean result = false;
        try {
            Subgraph nsGraph = this.store.getSubgraphOfDepth(2).at(this.parentOfNamespaceNodes);
            HashSet<Location> locationsToRemove = new HashSet<Location>();
            for (Location nsLocation : nsGraph.getRoot().getChildren()) {
                Object ns = nsGraph.getNode(nsLocation);
                String actualUri = stringFactory.create(ns.getProperty(this.uriPropertyName).getFirstValue());
                if (!actualUri.equals(uri)) continue;
                locationsToRemove.add(ns.getLocation());
                result = true;
            }
            Graph.Batch batch = this.store.batch();
            for (Location namespaceToRemove : locationsToRemove) {
                batch.delete(namespaceToRemove).and();
            }
            batch.execute();
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        return result;
    }
}

