/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class LocalNamespaceRegistry
extends SimpleNamespaceRegistry {
    private final NamespaceRegistry delegate;

    public LocalNamespaceRegistry(NamespaceRegistry delegate) {
        CheckArg.isNotNull(delegate, "delegate");
        this.delegate = delegate;
        this.unregister("");
    }

    public LocalNamespaceRegistry(NamespaceRegistry delegate, String defaultNamespaceUri) {
        CheckArg.isNotNull(delegate, "delegate");
        this.delegate = delegate;
        this.register("", defaultNamespaceUri);
    }

    @Override
    public String getDefaultNamespaceUri() {
        String result = super.getDefaultNamespaceUri();
        if (result == null) {
            result = this.delegate.getDefaultNamespaceUri();
        }
        return result;
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        String result = super.getNamespaceForPrefix(prefix);
        if (result == null && (result = this.delegate.getNamespaceForPrefix(prefix)) != null && super.getPrefixForNamespaceUri(result, false) != null) {
            return null;
        }
        return result;
    }

    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        Set<NamespaceRegistry.Namespace> delegateNamespaces = this.delegate.getNamespaces();
        Set<NamespaceRegistry.Namespace> localNamespaces = super.getNamespaces();
        if (localNamespaces.isEmpty()) {
            return delegateNamespaces;
        }
        HashSet<NamespaceRegistry.Namespace> namespaces = new HashSet<NamespaceRegistry.Namespace>(localNamespaces);
        HashMap<String, NamespaceRegistry.Namespace> localNamespacesByPrefix = new HashMap<String, NamespaceRegistry.Namespace>();
        for (NamespaceRegistry.Namespace ns : localNamespaces) {
            localNamespacesByPrefix.put(ns.getPrefix(), ns);
        }
        for (NamespaceRegistry.Namespace ns : delegateNamespaces) {
            if (localNamespacesByPrefix.get(ns.getPrefix()) != null) continue;
            namespaces.add(ns);
        }
        return Collections.unmodifiableSet(namespaces);
    }

    public Set<NamespaceRegistry.Namespace> getLocalNamespaces() {
        return super.getNamespaces();
    }

    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        String result = super.getPrefixForNamespaceUri(namespaceUri, false);
        if (result == null && (result = this.delegate.getPrefixForNamespaceUri(namespaceUri, false)) != null && !this.getNamespaceForPrefix(result).equals(namespaceUri)) {
            result = null;
        }
        if (result == null && generateIfMissing) {
            result = super.getPrefixForNamespaceUri(namespaceUri, true);
        }
        return result;
    }

    @Override
    public Set<String> getRegisteredNamespaceUris() {
        HashSet<String> uris = new HashSet<String>(this.delegate.getRegisteredNamespaceUris());
        uris.addAll(super.getRegisteredNamespaceUris());
        return Collections.unmodifiableSet(uris);
    }

    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        return super.isRegisteredNamespaceUri(namespaceUri) || this.delegate.isRegisteredNamespaceUri(namespaceUri);
    }

    @Override
    public String register(String prefix, String namespaceUri) {
        String previous = super.register(prefix, namespaceUri);
        if (previous == null && this.delegate != null) {
            previous = this.delegate.getPrefixForNamespaceUri(namespaceUri, false);
        }
        return previous;
    }

    @Override
    public boolean unregister(String namespaceUri) {
        return super.unregister(namespaceUri);
    }

    public NamespaceRegistry getDelegate() {
        return this.delegate;
    }
}

