/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.LanguageObject;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class Column
implements LanguageObject {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final String columnName;

    public Column(SelectorName selectorName) {
        CheckArg.isNotNull(selectorName, "selectorName");
        this.selectorName = selectorName;
        this.propertyName = null;
        this.columnName = null;
    }

    public Column(SelectorName selectorName, String propertyName, String columnName) {
        CheckArg.isNotNull(selectorName, "selectorName");
        CheckArg.isNotNull(propertyName, "propertyName");
        CheckArg.isNotNull(columnName, "columnName");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
    }

    public final SelectorName selectorName() {
        return this.selectorName;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public final String columnName() {
        return this.columnName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.selectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls(this.propertyName, that.propertyName)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.columnName, that.columnName);
        }
        return false;
    }

    public Column with(SelectorName newSelectorName) {
        return new Column(newSelectorName, this.propertyName, this.columnName);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

