/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class DescendantNodeJoinCondition
implements JoinCondition {
    private static final long serialVersionUID = 1L;
    private final SelectorName descendantSelectorName;
    private final SelectorName ancestorSelectorName;
    private final int hc;

    public DescendantNodeJoinCondition(SelectorName ancestorSelectorName, SelectorName descendantSelectorName) {
        CheckArg.isNotNull(descendantSelectorName, "descendantSelectorName");
        CheckArg.isNotNull(ancestorSelectorName, "ancestorSelectorName");
        this.descendantSelectorName = descendantSelectorName;
        this.ancestorSelectorName = ancestorSelectorName;
        this.hc = HashCode.compute(this.descendantSelectorName, this.ancestorSelectorName);
    }

    public final SelectorName descendantSelectorName() {
        return this.descendantSelectorName;
    }

    public final SelectorName ancestorSelectorName() {
        return this.ancestorSelectorName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition that = (DescendantNodeJoinCondition)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.descendantSelectorName.equals(that.descendantSelectorName)) {
                return false;
            }
            return this.ancestorSelectorName.equals(that.ancestorSelectorName);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

