/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.Readable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JoinType implements Readable
{
    INNER("INNER JOIN"),
    LEFT_OUTER("LEFT OUTER JOIN"),
    RIGHT_OUTER("RIGHT OUTER JOIN"),
    FULL_OUTER("FULL OUTER JOIN"),
    CROSS("CROSS JOIN");

    private static final Map<String, JoinType> TYPE_BY_SYMBOL;
    private final String symbol;

    private JoinType(String symbol) {
        this.symbol = symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public boolean isOuter() {
        return this.equals(LEFT_OUTER) || this.equals(FULL_OUTER) || this.equals(RIGHT_OUTER);
    }

    public String toString() {
        return this.symbol;
    }

    public static JoinType forSymbol(String symbol) {
        CheckArg.isNotNull(symbol, "symbol");
        return TYPE_BY_SYMBOL.get(symbol.toUpperCase());
    }

    @Override
    public String getString() {
        return this.symbol();
    }

    static {
        HashMap<String, JoinType> typesBySymbol = new HashMap<String, JoinType>();
        for (JoinType type : JoinType.values()) {
            typesBySymbol.put(type.symbol().toUpperCase(), type);
        }
        TYPE_BY_SYMBOL = Collections.unmodifiableMap(typesBySymbol);
    }
}

