/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.util.CheckArg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator {
    EQUAL_TO("="),
    NOT_EQUAL_TO("!="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL_TO("<="),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL_TO(">="),
    LIKE("LIKE");

    private static final Map<String, Operator> OPERATORS_BY_SYMBOL;
    private final String symbol;

    private Operator(String symbol) {
        this.symbol = symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public Operator reverse() {
        switch (this) {
            case GREATER_THAN: {
                return LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return LESS_THAN_OR_EQUAL_TO;
            }
            case LESS_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return GREATER_THAN_OR_EQUAL_TO;
            }
        }
        return this;
    }

    public boolean isRangeOperator() {
        switch (this) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL_TO: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.symbol;
    }

    public static Operator forSymbol(String symbol) {
        CheckArg.isNotNull(symbol, "symbol");
        return OPERATORS_BY_SYMBOL.get(symbol.toUpperCase());
    }

    static {
        HashMap<String, Operator> opsBySymbol = new HashMap<String, Operator>();
        for (Operator operator : Operator.values()) {
            opsBySymbol.put(operator.symbol().toUpperCase(), operator);
        }
        opsBySymbol.put("<>", NOT_EQUAL_TO);
        OPERATORS_BY_SYMBOL = Collections.unmodifiableMap(opsBySymbol);
    }
}

