/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.ImmutableColumn;
import org.modeshape.graph.query.validate.ImmutableKey;
import org.modeshape.graph.query.validate.ImmutableTable;
import org.modeshape.graph.query.validate.ImmutableView;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ImmutableSchemata
implements Schemata {
    private final Map<SelectorName, Schemata.Table> tables;

    public static Builder createBuilder(ExecutionContext context, TypeSystem typeSystem) {
        CheckArg.isNotNull(typeSystem, "typeSystem");
        return new Builder(context, typeSystem);
    }

    protected ImmutableSchemata(Map<SelectorName, Schemata.Table> tables) {
        this.tables = Collections.unmodifiableMap(tables);
    }

    @Override
    public Schemata.Table getTable(SelectorName name) {
        return this.tables.get(name);
    }

    public ImmutableSchemata with(Schemata.Table table) {
        HashMap<SelectorName, Schemata.Table> tables = new HashMap<SelectorName, Schemata.Table>(this.tables);
        tables.put(table.getName(), table);
        return new ImmutableSchemata(tables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Schemata.Table table : this.tables.values()) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(table);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MutableTable {
        private final SelectorName name;
        private final Map<String, Schemata.Column> columnsByName = new HashMap<String, Schemata.Column>();
        private final List<Schemata.Column> columns = new LinkedList<Schemata.Column>();
        private final Set<Schemata.Key> keys = new HashSet<Schemata.Key>();
        private boolean extraColumns = false;
        private final Set<String> columnNamesNotInSelectStar = new HashSet<String>();

        protected MutableTable(String name, List<Schemata.Column> columns, boolean extraColumns) {
            this.name = new SelectorName(name);
            this.columns.addAll(columns);
            for (Schemata.Column column : columns) {
                Schemata.Column existing = this.columnsByName.put(column.getName(), column);
                assert (existing == null);
            }
        }

        public SelectorName getName() {
            return this.name;
        }

        protected void addColumn(Schemata.Column column) {
            Schemata.Column existing = this.columnsByName.put(column.getName(), column);
            if (existing != null) {
                this.columns.remove(existing);
            }
            this.columns.add(column);
        }

        protected Schemata.Column getColumn(String name) {
            return this.columnsByName.get(name);
        }

        protected Set<String> getColumnNamesInSelectStar() {
            return this.columnNamesNotInSelectStar;
        }

        protected boolean addKey(Collection<Schemata.Column> keyColumns) {
            return this.keys.add(new ImmutableKey(keyColumns));
        }

        protected void setExtraColumns(boolean extraColumns) {
            this.extraColumns = extraColumns;
        }

        protected void excludeFromSelectStar(String columnName) {
            this.columnNamesNotInSelectStar.add(columnName);
        }

        protected Schemata.Table asImmutable() {
            Map<String, Schemata.Column> columnsByName = Collections.unmodifiableMap(this.columnsByName);
            List<Schemata.Column> columns = Collections.unmodifiableList(this.columns);
            Set<Schemata.Key> keys = Collections.unmodifiableSet(this.keys);
            List<Schemata.Column> columnsInSelectStar = new ArrayList();
            HashMap<String, Schemata.Column> columnsInSelectStarByName = new HashMap();
            for (Schemata.Column column : columns) {
                if (this.columnNamesNotInSelectStar.contains(column.getName())) continue;
                columnsInSelectStar.add(column);
                columnsInSelectStarByName.put(column.getName(), column);
            }
            columnsInSelectStar = Collections.unmodifiableList(columnsInSelectStar);
            columnsInSelectStarByName = Collections.unmodifiableMap(columnsInSelectStarByName);
            return new ImmutableTable(this.name, columnsByName, columns, keys, this.extraColumns, columnsInSelectStarByName, columnsInSelectStar);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Builder {
        private final ExecutionContext context;
        private final TypeSystem typeSystem;
        private final Map<String, MutableTable> tables = new HashMap<String, MutableTable>();
        private final Map<SelectorName, QueryCommand> viewDefinitions = new HashMap<SelectorName, QueryCommand>();
        private final Set<SelectorName> tablesOrViewsWithExtraColumns = new HashSet<SelectorName>();
        private final Map<String, Map<String, Boolean>> orderableColumnsByTableName = new HashMap<String, Map<String, Boolean>>();
        private final Map<String, Map<String, Set<Operator>>> operatorsForColumnsByTableName = new HashMap<String, Map<String, Set<Operator>>>();

        protected Builder(ExecutionContext context, TypeSystem typeSystem) {
            this.context = context;
            this.typeSystem = typeSystem;
        }

        public Builder addTable(String name, String ... columnNames) {
            CheckArg.isNotEmpty(name, "name");
            CheckArg.isNotEmpty(columnNames, "columnNames");
            ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
            int i = 0;
            for (String columnName : columnNames) {
                CheckArg.isNotEmpty(columnName, "columnName[" + i++ + "]");
                columns.add(new ImmutableColumn(columnName, this.typeSystem.getDefaultType()));
            }
            MutableTable table = new MutableTable(name, columns, false);
            this.tables.put(name, table);
            return this;
        }

        public Builder addTable(String name, String[] columnNames, String[] types) {
            CheckArg.isNotEmpty(name, "name");
            CheckArg.isNotEmpty(columnNames, "columnNames");
            CheckArg.isNotEmpty(types, "types");
            CheckArg.isEquals(columnNames.length, "columnNames.length", types.length, "types.length");
            ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
            assert (columnNames.length == types.length);
            for (int i = 0; i != columnNames.length; ++i) {
                String columnName = columnNames[i];
                CheckArg.isNotEmpty(columnName, "columnName[" + i + "]");
                columns.add(new ImmutableColumn(columnName, types[i]));
            }
            MutableTable table = new MutableTable(name, columns, false);
            this.tables.put(name, table);
            return this;
        }

        public Builder addView(String name, String definition) {
            CheckArg.isNotEmpty(name, "name");
            CheckArg.isNotEmpty(definition, "definition");
            SqlQueryParser parser = new SqlQueryParser();
            QueryCommand command = parser.parseQuery(definition, this.typeSystem);
            this.viewDefinitions.put(new SelectorName(name), command);
            return this;
        }

        public Builder addView(String name, QueryCommand definition) {
            CheckArg.isNotEmpty(name, "name");
            CheckArg.isNotNull(definition, "definition");
            this.viewDefinitions.put(new SelectorName(name), definition);
            return this;
        }

        public Builder addColumn(String tableName, String columnName, String type) {
            CheckArg.isNotEmpty(tableName, "tableName");
            CheckArg.isNotEmpty(columnName, "columnName");
            CheckArg.isNotNull(type, "type");
            return this.addColumn(tableName, columnName, type, false, true, ImmutableColumn.ALL_OPERATORS);
        }

        public Builder addColumn(String tableName, String columnName, String type, boolean fullTextSearchable, boolean orderable, Set<Operator> operations) {
            CheckArg.isNotEmpty(tableName, "tableName");
            CheckArg.isNotEmpty(columnName, "columnName");
            CheckArg.isNotNull(type, "type");
            MutableTable existing = this.tables.get(tableName);
            ImmutableColumn column = new ImmutableColumn(columnName, type, fullTextSearchable, orderable, operations);
            if (existing == null) {
                ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
                columns.add(column);
                existing = new MutableTable(tableName, columns, false);
                this.tables.put(tableName, existing);
            } else {
                existing.addColumn(column);
            }
            return this;
        }

        public Builder makeSearchable(String tableName, String columnName) {
            CheckArg.isNotEmpty(tableName, "tableName");
            CheckArg.isNotEmpty(columnName, "columnName");
            MutableTable existing = this.tables.get(tableName);
            if (existing == null) {
                ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
                columns.add(new ImmutableColumn(columnName, this.typeSystem.getDefaultType(), true, true, ImmutableColumn.ALL_OPERATORS));
                existing = new MutableTable(tableName, columns, false);
                this.tables.put(tableName, existing);
            } else {
                Schemata.Column column = existing.getColumn(columnName);
                if (column != null && !column.isFullTextSearchable()) {
                    boolean orderable = column.isOrderable();
                    Set<Operator> operators = column.getOperators();
                    column = new ImmutableColumn(columnName, column.getPropertyType(), true, orderable, operators);
                }
                existing.addColumn(column);
            }
            return this;
        }

        public Builder markOrderable(String tableName, String columnName, boolean orderable) {
            CheckArg.isNotEmpty(tableName, "tableName");
            Map<String, Boolean> byColumnNames = this.orderableColumnsByTableName.get(tableName);
            if (byColumnNames == null) {
                byColumnNames = new HashMap<String, Boolean>();
                this.orderableColumnsByTableName.put(tableName, byColumnNames);
            }
            byColumnNames.put(columnName, orderable);
            return this;
        }

        protected boolean orderable(SelectorName tableName, String columnName, boolean defaultValue) {
            Boolean value;
            Map<String, Boolean> byColumnNames = this.orderableColumnsByTableName.get(tableName.getString());
            if (byColumnNames != null && (value = byColumnNames.get(columnName)) != null) {
                return value;
            }
            return defaultValue;
        }

        public Builder markOperators(String tableName, String columnName, Set<Operator> operators) {
            CheckArg.isNotEmpty(tableName, "tableName");
            boolean useDefaults = operators == null || operators.isEmpty();
            Map<String, Set<Operator>> byColumnNames = this.operatorsForColumnsByTableName.get(tableName);
            if (byColumnNames == null) {
                if (useDefaults) {
                    return this;
                }
                byColumnNames = new HashMap<String, Set<Operator>>();
                this.operatorsForColumnsByTableName.put(tableName, byColumnNames);
            }
            if (useDefaults) {
                byColumnNames.remove(columnName);
                if (byColumnNames.isEmpty()) {
                    this.operatorsForColumnsByTableName.remove(tableName);
                }
            } else {
                EnumSet<Operator> opSet = EnumSet.copyOf(operators);
                byColumnNames.put(columnName, opSet);
            }
            return this;
        }

        protected Set<Operator> operators(SelectorName tableName, String columnName, Set<Operator> defaultOperators) {
            Set<Operator> ops;
            Map<String, Set<Operator>> byColumnNames = this.operatorsForColumnsByTableName.get(tableName.getString());
            if (byColumnNames != null && (ops = byColumnNames.get(columnName)) != null) {
                return ops;
            }
            return defaultOperators;
        }

        public Builder markExtraColumns(String tableName) {
            CheckArg.isNotEmpty(tableName, "tableName");
            this.tablesOrViewsWithExtraColumns.add(new SelectorName(tableName));
            return this;
        }

        public Builder excludeFromSelectStar(String tableName, String columnName) {
            CheckArg.isNotEmpty(tableName, "tableName");
            CheckArg.isNotEmpty(columnName, "columnName");
            MutableTable existing = this.tables.get(tableName);
            if (existing == null) {
                ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
                columns.add(new ImmutableColumn(columnName, this.typeSystem.getDefaultType(), true, true, ImmutableColumn.ALL_OPERATORS));
                existing = new MutableTable(tableName, columns, false);
                this.tables.put(tableName, existing);
            }
            existing.excludeFromSelectStar(columnName);
            return this;
        }

        public Builder addKey(String tableName, String ... columnNames) {
            CheckArg.isNotEmpty(tableName, "tableName");
            CheckArg.isNotEmpty(columnNames, "columnNames");
            MutableTable existing = this.tables.get(tableName);
            if (existing == null) {
                throw new IllegalArgumentException(GraphI18n.tableDoesNotExist.text(tableName));
            }
            HashSet<Schemata.Column> keyColumns = new HashSet<Schemata.Column>();
            for (String columnName : columnNames) {
                Schemata.Column existingColumn = existing.getColumn(columnName);
                if (existingColumn == null) {
                    String msg = GraphI18n.schemataKeyReferencesNonExistingColumn.text(tableName, columnName);
                    throw new IllegalArgumentException(msg);
                }
                keyColumns.add(existingColumn);
            }
            existing.addKey(keyColumns);
            return this;
        }

        public Schemata build() {
            HashMap<SelectorName, Schemata.Table> tablesByName = new HashMap<SelectorName, Schemata.Table>();
            for (MutableTable mutableTable : this.tables.values()) {
                if (this.tablesOrViewsWithExtraColumns.contains(mutableTable.getName())) {
                    mutableTable.setExtraColumns(true);
                }
                Schemata.Table table = mutableTable.asImmutable();
                tablesByName.put(table.getName(), table);
            }
            ImmutableSchemata schemata = new ImmutableSchemata(tablesByName);
            HashMap<SelectorName, QueryCommand> definitions = new HashMap<SelectorName, QueryCommand>(this.viewDefinitions);
            boolean added = false;
            do {
                added = false;
                HashSet viewNames = new HashSet(definitions.keySet());
                for (SelectorName name : viewNames) {
                    QueryCommand command = (QueryCommand)definitions.get(name);
                    PlanHints hints = new PlanHints();
                    hints.validateColumnExistance = false;
                    QueryContext queryContext = new QueryContext(this.context, schemata, this.typeSystem, hints);
                    CanonicalPlanner planner = new CanonicalPlanner();
                    PlanNode plan = planner.createPlan(queryContext, command);
                    if (queryContext.getProblems().hasErrors()) continue;
                    PlanNode project = plan.findAtOrBelow(PlanNode.Type.PROJECT);
                    assert (project != null);
                    List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                    assert (!columns.isEmpty());
                    Map<SelectorName, SelectorName> tableNameByAlias = null;
                    ArrayList<Schemata.Column> viewColumns = new ArrayList<Schemata.Column>(columns.size());
                    ArrayList<Schemata.Column> viewColumnsInSelectStar = new ArrayList<Schemata.Column>(columns.size());
                    HashSet<String> columnNames = new HashSet<String>();
                    for (Column column : columns) {
                        String viewColumnName;
                        Schemata.Table source = schemata.getTable(column.selectorName());
                        if (source == null) {
                            SelectorName tableName;
                            if (tableNameByAlias == null) {
                                tableNameByAlias = Visitors.getSelectorNamesByAlias(command);
                            }
                            if ((tableName = tableNameByAlias.get(column.selectorName())) != null) {
                                source = schemata.getTable(tableName);
                            }
                            if (source == null) continue;
                        }
                        if (columnNames.contains(viewColumnName = column.columnName())) continue;
                        String sourceColumnName = column.propertyName();
                        Schemata.Column sourceColumn = source.getColumn(sourceColumnName);
                        if (sourceColumn == null) {
                            throw new InvalidQueryException(Visitors.readable(command), "The view references a non-existant column '" + column.columnName() + "' in '" + source.getName() + "'");
                        }
                        Set<Operator> operators = this.operators(name, viewColumnName, sourceColumn.getOperators());
                        boolean orderable = this.orderable(name, viewColumnName, sourceColumn.isOrderable());
                        ImmutableColumn newColumn = new ImmutableColumn(viewColumnName, sourceColumn.getPropertyType(), sourceColumn.isFullTextSearchable(), orderable, operators);
                        viewColumns.add(newColumn);
                        if (source.getSelectAllColumnsByName().containsKey(sourceColumnName)) {
                            viewColumnsInSelectStar.add(newColumn);
                        }
                        columnNames.add(newColumn.getName());
                    }
                    HashMap<String, Schemata.Column> viewColumnsByName = new HashMap<String, Schemata.Column>();
                    HashMap<String, Schemata.Column> viewSelectStarColumnsByName = new HashMap<String, Schemata.Column>();
                    for (Schemata.Column column : viewColumns) {
                        viewColumnsByName.put(column.getName(), column);
                    }
                    for (Schemata.Column column : viewColumnsInSelectStar) {
                        viewSelectStarColumnsByName.put(column.getName(), column);
                    }
                    Set<Schemata.Key> keys = Collections.emptySet();
                    boolean hasExtraColumns = this.tablesOrViewsWithExtraColumns.contains(name);
                    ImmutableView view = new ImmutableView(name, viewColumnsByName, viewColumns, hasExtraColumns, command, keys, viewSelectStarColumnsByName, viewColumnsInSelectStar);
                    definitions.remove(name);
                    tablesByName.put(view.getName(), view);
                    schemata = new ImmutableSchemata(tablesByName);
                    added = true;
                }
            } while (added && !definitions.isEmpty());
            if (!definitions.isEmpty()) {
                QueryCommand command = (QueryCommand)definitions.values().iterator().next();
                throw new InvalidQueryException(Visitors.readable(command), "The view definition cannot be resolved: " + Visitors.readable(command));
            }
            return schemata;
        }
    }
}

