/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteChildrenRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;
    private List<Location> actualChildrenDeleted = new LinkedList<Location>();

    public DeleteChildrenRequest(Location at, String workspaceName) {
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public void addDeletedChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, "children");
        for (Location child : children) {
            if (child == null) continue;
            this.actualChildrenDeleted.add(child);
        }
    }

    public void addDeletedChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull(child, "child");
        this.actualChildrenDeleted.add(child);
    }

    public void addDeletedChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.actualChildrenDeleted.add(child);
    }

    public void addDeletedChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.actualChildrenDeleted.add(child);
    }

    public List<Location> getActualChildrenDeleted() {
        return this.actualChildrenDeleted;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.at;
    }

    @Override
    public String changedWorkspace() {
        return this.workspaceName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            DeleteChildrenRequest that = (DeleteChildrenRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        return "delete children of " + this.printable(this.at()) + " (in " + workspaceName + " workspace)";
    }

    @Override
    public DeleteChildrenRequest clone() {
        return new DeleteChildrenRequest(this.at, this.workspaceName);
    }

    @Override
    public RequestType getType() {
        return RequestType.DELETE_CHILDREN;
    }
}

