/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.function.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionRequest
extends Request
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private final Function function;
    private final Map<String, Serializable> inputs;
    private final Map<String, Serializable> outputs;
    private List<Request> requests;
    private Location actualLocation;

    public FunctionRequest(Function function, Location at, String workspaceName, Map<String, Serializable> inputs) {
        CheckArg.isNotNull(function, "function");
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.function = function;
        this.inputs = inputs != null ? inputs : Collections.emptyMap();
        this.outputs = new HashMap<String, Serializable>();
    }

    @Override
    public boolean isReadOnly() {
        return this.function.isReadOnly();
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Map<String, Serializable> inputs() {
        return this.inputs;
    }

    public Object input(String name) {
        return this.inputs.get(name);
    }

    public <T> T input(String name, Class<T> type, T defaultValue, ExecutionContext context) {
        return this.convert(name, type, defaultValue, this.inputs, context);
    }

    public <T> T input(String name, PropertyType type, T defaultValue, ExecutionContext context) {
        return this.convert(name, type, defaultValue, this.inputs, context);
    }

    public Function function() {
        return this.function;
    }

    public Map<String, Serializable> outputs() {
        return this.outputs;
    }

    public Object output(String name) {
        return this.outputs.get(name);
    }

    public <T> T output(String name, Class<T> type, ExecutionContext context) {
        return this.convert(name, type, null, this.outputs, context);
    }

    public <T> T output(String name, Class<T> type, T defaultValue, ExecutionContext context) {
        return this.convert(name, type, defaultValue, this.outputs, context);
    }

    public <T> T output(String name, PropertyType type, T defaultValue, ExecutionContext context) {
        return this.convert(name, type, defaultValue, this.outputs, context);
    }

    public Serializable setOutput(String name, Serializable value) {
        this.checkNotFrozen();
        CheckArg.isNotEmpty(name, "name");
        return value != null ? this.outputs.put(name, value) : this.outputs.remove(name);
    }

    public void addActualRequest(Request request) {
        this.checkNotFrozen();
        CheckArg.isNotNull(request, "request");
        if (this.requests == null) {
            this.requests = new ArrayList<Request>();
        }
        this.requests.add(request);
    }

    public void addActualRequests(Iterable<Request> requests) {
        this.checkNotFrozen();
        CheckArg.isNotNull(requests, "requests");
        if (this.requests == null) {
            requests = new ArrayList<Request>();
        }
        for (Request request : requests) {
            if (request == null) continue;
            this.requests.add(request);
        }
    }

    public int getActualRequestCount() {
        return this.requests != null ? this.requests.size() : 0;
    }

    public Iterator<Request> getActualRequests() {
        if (this.requests != null) {
            return this.requests.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
        this.outputs.clear();
    }

    public int hashCode() {
        return HashCode.compute(this.at, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            FunctionRequest that = (FunctionRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            if (!this.inWorkspace().equals(that.inWorkspace())) {
                return false;
            }
            if (!this.function.getClass().equals(that.function.getClass())) {
                return false;
            }
            return ((Object)this.inputs()).equals(that.inputs());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        String functionName = this.function.getClass().getSimpleName();
        return "applyfn at " + this.printable(this.at()) + " (in " + workspaceName + " workspace) the " + functionName;
    }

    @Override
    public RequestType getType() {
        return RequestType.FUNCTION;
    }

    public FunctionRequest clone() {
        return new FunctionRequest(this.function, this.at, this.workspaceName, this.inputs);
    }

    protected final <T> T convert(String name, Class<T> type, T defaultValue, Map<String, Serializable> values, ExecutionContext context) {
        Serializable value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        PropertyType propertyType = PropertyType.discoverType(type);
        if (propertyType != null) {
            ValueFactory<?> factory = context.getValueFactories().getValueFactory(propertyType);
            return (T)factory.create(value);
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        String msg = GraphI18n.errorConvertingType.text(value.getClass().getSimpleName(), type.getSimpleName(), value);
        throw new ValueFormatException((Object)value, PropertyType.OBJECT, msg);
    }

    protected final <T> T convert(String name, PropertyType type, T defaultValue, Map<String, Serializable> values, ExecutionContext context) {
        Serializable value = values.get(name);
        if (value == null) {
            return defaultValue;
        }
        ValueFactory<?> factory = context.getValueFactories().getValueFactory(type);
        return (T)factory.create(value);
    }
}

