/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class UnlockBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;

    public UnlockBranchRequest(Location at, String workspaceName) {
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public void setActualLocation(Location actualLocation) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actualLocation, "actualLocation");
        if (!actualLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(actualLocation));
        }
        this.actualLocation = actualLocation;
    }

    public Location getActualLocation() {
        return this.actualLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().getParent().isAtOrBelow(path);
    }

    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.at;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute(this.at, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            UnlockBranchRequest that = (UnlockBranchRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        return "unlock " + this.printable(this.at()) + " (in " + workspaceName + " workspace)";
    }

    public UnlockBranchRequest clone() {
        UnlockBranchRequest request = new UnlockBranchRequest(this.actualLocation != null ? this.actualLocation : this.at, this.workspaceName);
        request.setActualLocation(this.actualLocation);
        return request;
    }

    public RequestType getType() {
        return RequestType.UNLOCK_BRANCH;
    }
}

