/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionContaining;
import org.modeshape.graph.Node;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNodeWithProperty
extends TypeSafeMatcher<Node> {
    private final String propertyNameStr;
    private final Name propertyName;
    private final Matcher<Iterable<Object>> valueMatcher;

    public IsNodeWithProperty(String propertyNameStr, Name propertyName, Matcher<Iterable<Object>> valueMatcher) {
        this.propertyNameStr = propertyNameStr;
        this.propertyName = propertyName;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(Node node) {
        Property prop;
        Property property = prop = this.propertyNameStr != null ? node.getProperty(this.propertyNameStr) : node.getProperty(this.propertyName);
        if (prop != null) {
            return this.valueMatcher.matches((Object)prop);
        }
        return false;
    }

    public void describeTo(Description description) {
        String name = this.propertyNameStr != null ? this.propertyNameStr : this.propertyName;
        description.appendText("a property \"" + name + "\"containing ").appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static IsNodeWithProperty hasProperty(Name name, Object ... values) {
        return new IsNodeWithProperty(null, name, (Matcher<Iterable<Object>>)IsCollectionContaining.hasItems((Object[])values));
    }

    @Factory
    public static IsNodeWithProperty hasProperty(String name, Object ... values) {
        return new IsNodeWithProperty(name, null, (Matcher<Iterable<Object>>)IsCollectionContaining.hasItems((Object[])values));
    }
}

