/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.LogContext;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositoryOperation;
import org.modeshape.graph.connector.RepositorySourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(ExecutionContext context, RepositoryConnectionPool pool, RepositoryOperation<T> operation) throws RepositorySourceException, InterruptedException {
        CheckArg.isNotNull(operation, (String)"repository operation");
        T result = null;
        LogContext.set((String)"context", (String)operation.getName());
        RepositoryConnection conn = pool.getConnection();
        try {
            result = operation.run(context, conn);
        }
        finally {
            conn.close();
        }
        LogContext.clear();
        return result;
    }

    public static <T> Callable<T> createCallable(final ExecutionContext context, final RepositoryConnectionPool pool, final RepositoryOperation<T> operation) {
        CheckArg.isNotNull(operation, (String)"repository operation");
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RepositoryOperations.call(context, pool, operation);
            }
        };
    }

    public static <T> List<Callable<T>> createCallables(ExecutionContext context, RepositoryConnectionPool pool, RepositoryOperation<T> ... operations) {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>();
        for (RepositoryOperation<T> operation : operations) {
            callables.add(RepositoryOperations.createCallable(context, pool, operation));
        }
        return callables;
    }

    public static <T> List<Callable<T>> createCallables(ExecutionContext context, RepositoryConnectionPool pool, Iterable<RepositoryOperation<T>> operations) {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>();
        for (RepositoryOperation<T> operation : operations) {
            callables.add(RepositoryOperations.createCallable(context, pool, operation));
        }
        return callables;
    }

    public static <T> List<Callable<T>> createCallables(ExecutionContext context, RepositoryConnectionPool pool, Iterator<RepositoryOperation<T>> operations) {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>();
        while (operations.hasNext()) {
            RepositoryOperation<T> operation = operations.next();
            callables.add(RepositoryOperations.createCallable(context, pool, operation));
        }
        return callables;
    }
}

