/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.PlaceholderNode;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.Projector;
import org.modeshape.graph.property.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectorTest<ProjectorType extends Projector> {
    protected ExecutionContext context;
    protected List<Projection> projections;
    protected ProjectorType projector;
    protected Location locationA;
    protected Location locationB;
    protected Location locationAB;
    protected Location locationABCD;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.projections = new ArrayList<Projection>();
        this.locationA = Location.create((Path)this.path("/a"));
        this.locationB = Location.create((Path)this.path("/b"));
        this.locationAB = Location.create((Path)this.path("/a/b"));
        this.locationABCD = Location.create((Path)this.path("/a/b/c/d"));
    }

    protected Projection.Rule[] rule(String ... rule) {
        Projection.Rule[] rules = new Projection.Rule[rule.length];
        for (int i = 0; i != rule.length; ++i) {
            rules[i] = Projection.fromString((String)rule[i], (ExecutionContext)this.context);
        }
        return rules;
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Path path(Path parent, String relativePath) {
        return this.context.getValueFactories().getPathFactory().create(parent, relativePath);
    }

    protected void addProjection(String sourceName, String workspaceName, String ... rules) {
        this.projections.add(new Projection(sourceName, workspaceName, false, this.rule(rules)));
    }

    protected void clearProjections() {
        this.projections.clear();
    }

    protected Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    protected Location location(String path) {
        return Location.create((Path)this.path(path));
    }

    protected Location location(UUID uuid) {
        return Location.create((UUID)uuid);
    }

    protected void assertNoProjectedNodeAt(String path) {
        ProjectedNode node = this.projector.project(this.context, this.location(path), false);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    protected void assertPlacholderHasChildren(String parent, String ... childSegments) {
        Path parentPath = this.path(parent);
        ProjectedNode node = this.projector.project(this.context, Location.create((Path)parentPath), false);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.isPlaceholder(), (Matcher)Is.is((Object)true));
        PlaceholderNode placeholder = node.asPlaceholder();
        ArrayList<Path> locations = new ArrayList<Path>();
        for (String childSegment : childSegments) {
            Path childPath = this.path(parentPath, childSegment);
            locations.add(childPath);
        }
        ArrayList<Path> actual = new ArrayList<Path>();
        for (ProjectedNode child : placeholder.children()) {
            if (child.isPlaceholder()) {
                actual.add(child.location().getPath());
                continue;
            }
            actual.add(child.asProxy().federatedLocation().getPath());
        }
        Assert.assertThat(actual, (Matcher)Is.is(locations));
    }
}

