/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

public class PathFactoryTest {
    private ExecutionContext context;
    private PathFactory paths;
    private Path path;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("ex", "http://www.example.com");
        this.paths = this.context.getValueFactories().getPathFactory();
    }

    public Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public Path.Segment segment(String segment) {
        return this.paths.createSegment(segment);
    }

    @Test
    public void shouldCreateRootPath() {
        Assert.assertThat((Object)this.paths.createRootPath(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateRootPathWithNoSegments() {
        Assert.assertThat((Object)this.paths.createRootPath().getSegmentsList().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.paths.createRootPath().getSegmentsList().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.paths.createRootPath().getSegmentsArray().length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.paths.createRootPath().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCreateRootPathWithLengthOfZero() {
        Assert.assertThat((Object)this.paths.createRootPath().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCreateRootPathThatIsAbsolute() {
        Assert.assertThat((Object)this.paths.createRootPath().isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateRootPathThatHasNoParent() {
        Assert.assertThat((Object)this.paths.createRootPath().getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnRootPathsThatAreAlwaysEquivalent() {
        this.path = this.paths.createRootPath();
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)this.paths.createRootPath(), (Matcher)Is.is((Object)this.path));
        }
    }

    @Test
    public void shouldCreateRelativePathWithOnlySelf() {
        this.path = (Path)this.paths.create(".");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateRelativePathWithOnlySelfSegment() {
        this.path = this.paths.createRelativePath(new Name[]{this.name(".")});
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateRelativePathWithSingleSegment() {
        this.path = (Path)this.paths.create("A");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateRelativePathWithMultipleSegment() {
        this.path = (Path)this.paths.create("A/B/C[1]/D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldCreateRelativePathWithMultipleSegmentIncludingParent() {
        this.path = (Path)this.paths.create("A/B/C[1]/../../D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldCreateRelativePathWithMultipleSegmentIncludingSelf() {
        this.path = (Path)this.paths.create("A/B/C[1]/././D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldCreateRelativePathWithMultipleSegmentIncludingSelfAndParent() {
        this.path = (Path)this.paths.create("A/B/C[1]/../D[2]/./E/..");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(6), (Matcher)Is.is((Object)this.segment("E[1]")));
        Assert.assertThat((Object)this.path.getSegment(7), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void shouldNormalizeRelativePathWithMultipleSegmentIncludingSelfAndParent() {
        Assert.assertThat((Object)((Path)this.paths.create("A/B/C[1]/../D[2]/./E/..")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("A/B/D[2]")));
        Assert.assertThat((Object)((Path)this.paths.create("A/B/C[1]/././D[2]")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("A/B/C/D[2]")));
        Assert.assertThat((Object)((Path)this.paths.create("A/../../../B")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("../../B")));
        Assert.assertThat((Object)((Path)this.paths.create("../../B")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("../../B")));
        Assert.assertThat((Object)((Path)this.paths.create("./B")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("B")));
        Assert.assertThat((Object)((Path)this.paths.create("A/./../../B/.")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("../B")));
    }

    @Test
    public void shouldCreateAbsolutePathWithOnlySelf() {
        this.path = (Path)this.paths.create("/.");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateAbsolutePathWithOnlySelfSegment() {
        this.path = (Path)this.paths.create(this.name("."));
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateAbsolutePathWithSingleSegment() {
        this.path = (Path)this.paths.create("/A");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCreateAbsolutePathWithMultipleSegment() {
        this.path = (Path)this.paths.create("/A/B/C[1]/D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldCreateAbsolutePathWithMultipleSegmentIncludingParent() {
        this.path = (Path)this.paths.create("/A/B/C[1]/../../D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldCreateAbsolutePathWithMultipleSegmentIncludingSelf() {
        this.path = (Path)this.paths.create("/A/B/C[1]/././D[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldCreateAbsolutePathWithMultipleSegmentIncludingSelfAndParent() {
        this.path = (Path)this.paths.create("/A/B/C[1]/../D[2]/./E/..");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(4), (Matcher)Is.is((Object)this.segment("D[2]")));
        Assert.assertThat((Object)this.path.getSegment(5), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.getSegment(6), (Matcher)Is.is((Object)this.segment("E[1]")));
        Assert.assertThat((Object)this.path.getSegment(7), (Matcher)Is.is((Object)Path.PARENT_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void shouldNormalizeAbsolutePathWithMultipleSegmentIncludingSelfAndParent() {
        Assert.assertThat((Object)((Path)this.paths.create("/A/B/C[1]/../D[2]/./E/..")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("/A/B/D[2]")));
        Assert.assertThat((Object)((Path)this.paths.create("/A/B/C[1]/././D[2]")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("/A/B/C/D[2]")));
        Assert.assertThat((Object)((Path)this.paths.create("/./B")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("/B")));
        Assert.assertThat((Object)((Path)this.paths.create("/./././B")).getNormalizedPath(), (Matcher)Is.is((Object)this.paths.create("/B")));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldFailToCreateAbsolutePathWithMoreParentReferencesThanDepth() {
        ((Path)this.paths.create("/A/../../../B")).getNormalizedPath();
    }

    @Test
    public void shouldParsePathFromStringWithRootSegment() {
        Assert.assertThat((Object)((Path)this.paths.create("/")).isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldParsePathFromStringWithRootSegmentAndSelfSegment() {
        this.path = (Path)this.paths.create("/.");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)Path.SELF_SEGMENT));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParsePathFromStringWithSingleChildSegment() {
        this.path = (Path)this.paths.create("/A");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParsePathFromStringWithMultipleChildSegments() {
        this.path = (Path)this.paths.create("/A/B/C");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldParsePathFromStringWithSingleChildSegmentWithSameNameSiblingIndex() {
        this.path = (Path)this.paths.create("/A[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParsePathFromStringWithMultipleChildSegmentsWithSameNameSiblingIndex() {
        this.path = (Path)this.paths.create("/A/B[2]/C");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[2]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldParsePathFromStringWithTrailingSlash() {
        this.path = (Path)this.paths.create("/A/B/C/D/");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithoutTrailingSlash() {
        this.path = (Path)this.paths.create("/A/B/C/D");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringEndingWithSameNameSiblingIndexButWithoutTrailingSlash() {
        this.path = (Path)this.paths.create("/A/B/C/D[3]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[3]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithRootSegmentAndIdentifierSegment() {
        this.path = (Path)this.paths.create("/A/B/C/D[3]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[3]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithSingleChildSegment() {
        this.path = (Path)this.paths.create("/ex:A");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("ex:A[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithMultipleChildSegments() {
        this.path = (Path)this.paths.create("/ex:A/B/ex:C");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("ex:A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("ex:C[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithSingleChildSegmentWithSameNameSiblingIndex() {
        this.path = (Path)this.paths.create("/ex:A[2]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("ex:A[2]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithMultipleChildSegmentsWithSameNameSiblingIndex() {
        this.path = (Path)this.paths.create("/ex:A/ex:B[2]/ex:C");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("ex:A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("ex:B[2]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("ex:C[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithTrailingSlash() {
        this.path = (Path)this.paths.create("/A/B/C/D/");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndWithoutTrailingSlash() {
        this.path = (Path)this.paths.create("/ex:A/ex:B/ex:C/ex:D");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("ex:A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("ex:B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("ex:C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("ex:D[1]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndEndingWithSameNameSiblingIndexButWithoutTrailingSlash() {
        this.path = (Path)this.paths.create("/A/ex:B/ex:C/ex:D[3]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("ex:B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("ex:C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("ex:D[3]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithNamespacesAndRootSegmentAndIdentifierSegment() {
        this.path = (Path)this.paths.create("/A/B/C/D[3]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("A[1]")));
        Assert.assertThat((Object)this.path.getSegment(1), (Matcher)Is.is((Object)this.segment("B[1]")));
        Assert.assertThat((Object)this.path.getSegment(2), (Matcher)Is.is((Object)this.segment("C[1]")));
        Assert.assertThat((Object)this.path.getSegment(3), (Matcher)Is.is((Object)this.segment("D[3]")));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void shouldParsePathFromStringWithoutRootSegmentAndIdentifierSegment() {
        this.path = (Path)this.paths.create("[f81d4fae-7dec-11d0-a765-00a0c91e6bf6]");
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isIdentifier(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.path.getSegment(0), (Matcher)Is.is((Object)this.segment("[f81d4fae-7dec-11d0-a765-00a0c91e6bf6]")));
        Assert.assertThat((Object)this.path.getSegment(0).getName(), (Matcher)Is.is((Object)this.name("f81d4fae-7dec-11d0-a765-00a0c91e6bf6")));
        Assert.assertThat((Object)this.path.getSegment(0).getIndex(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.path.getSegment(0).isIdentifier(), (Matcher)Is.is((Object)true));
    }
}

