/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractPathTest;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.IsPathContaining;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.RootPath;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class BasicPathTest
extends AbstractPathTest {
    public static final TextEncoder NO_OP_ENCODER = Path.NO_OP_ENCODER;
    public static final Path ROOT = RootPath.INSTANCE;
    private NamespaceRegistry namespaceRegistry;
    private String validNamespaceUri;
    private Path path2;
    private Path.Segment[] validSegments;
    private List<Path.Segment> validSegmentsList;
    private Name[] validSegmentNames;
    private String validNamespacePrefix;
    private PathValueFactory pathFactory;

    @Before
    public void beforeEach() {
        this.validNamespacePrefix = "mode";
        this.validNamespaceUri = "http://www.modeshape.org/1.0";
        this.validSegmentNames = new Name[]{new BasicName(this.validNamespaceUri, "a"), new BasicName(this.validNamespaceUri, "b"), new BasicName(this.validNamespaceUri, "c")};
        this.validSegments = new Path.Segment[]{new BasicPathSegment(this.validSegmentNames[0]), new BasicPathSegment(this.validSegmentNames[1]), new BasicPathSegment(this.validSegmentNames[1])};
        this.validSegmentsList = new ArrayList<Path.Segment>();
        for (Path.Segment segment : this.validSegments) {
            this.validSegmentsList.add(segment);
        }
        this.path = new BasicPath(this.validSegmentsList, true);
        this.namespaceRegistry = new SimpleNamespaceRegistry();
        this.namespaceRegistry.register(this.validNamespacePrefix, this.validNamespaceUri);
        StringValueFactory stringValueFactory = new StringValueFactory(this.namespaceRegistry, Path.DEFAULT_DECODER, Path.DEFAULT_ENCODER);
        NameValueFactory nameValueFactory = new NameValueFactory(this.namespaceRegistry, Path.DEFAULT_DECODER, (ValueFactory)stringValueFactory);
        this.pathFactory = new PathValueFactory(Path.DEFAULT_DECODER, (ValueFactory)stringValueFactory, (ValueFactory)nameValueFactory);
    }

    @Test
    public void shouldCreateAbsolutePathFromListOfValidSegments() {
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateRelativePathFromListOfValidSegments() {
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedAnAbsolutePathWithParentSegmentAtEnd() {
        this.validSegmentsList.add(Path.PARENT_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedARelativePathWithParentSegmentAtEnd() {
        this.validSegmentsList.add(Path.PARENT_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedAnAbsolutePathWithParentSegmentAtFront() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        segments.add(Path.PARENT_SEGMENT);
        segments.addAll(this.validSegmentsList);
        this.path = new BasicPath(segments, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)segments.size()));
    }

    @Test
    public void shouldConsiderAsNormalizedARelativePathWithParentSegmentAtFront() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        segments.add(Path.PARENT_SEGMENT);
        segments.addAll(this.validSegmentsList);
        this.path = new BasicPath(segments, false);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)segments.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedAnAbsolutePathWithAllParentReferences() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        for (int i = 0; i != 10; ++i) {
            segments.add(Path.PARENT_SEGMENT);
        }
        this.path = new BasicPath(segments, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)segments.size()));
    }

    @Test
    public void shouldConsiderAsNormalizedARelativePathWithAllParentReferences() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        for (int i = 0; i != 10; ++i) {
            segments.add(Path.PARENT_SEGMENT);
        }
        this.path = new BasicPath(segments, false);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)segments.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedPathWithMostParentReferencesAndOneNonParentReferenceInMiddle() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        segments.add(Path.PARENT_SEGMENT);
        segments.add(Path.PARENT_SEGMENT);
        segments.add(this.pathFactory.createSegment("nonParentSegment"));
        segments.add(Path.PARENT_SEGMENT);
        segments.add(Path.PARENT_SEGMENT);
        this.path = new BasicPath(segments, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(segments));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)segments.size()));
    }

    @Test
    public void shouldConsiderAsNotNormalizedAnAbsolutePathThatBeginsWithParentReference() {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>();
        segments.add(Path.PARENT_SEGMENT);
        segments.add(this.pathFactory.createSegment("nonParentSegment"));
        segments.add(this.pathFactory.createSegment("nonParentSegment2"));
        this.path = new BasicPath(segments, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateAbsolutePathWithSelfSegment() {
        this.validSegmentsList.add(Path.SELF_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateRelativePathWithSelfSegment() {
        this.validSegmentsList.add(Path.SELF_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getSegmentsList(), (Matcher)Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreatePathWithNoNamespacePrefixes() {
        this.path = this.pathFactory.create("/a/b/c/");
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c"));
    }

    @Test
    public void shouldConstructRelativePath() {
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").getString(this.namespaceRegistry), (Matcher)Is.is((Object)"a/b/c"));
    }

    @Test
    public void shouldConstructRelativePathToSelf() {
        Assert.assertThat((Object)this.pathFactory.create(".").isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create(".").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.pathFactory.create("."), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
        Assert.assertThat((Object)this.pathFactory.create("./").isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("./").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.pathFactory.create("./"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
    }

    @Test
    public void shouldConstructRelativePathToParent() {
        Assert.assertThat((Object)this.pathFactory.create("..").isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("..").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.pathFactory.create(".."), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        Assert.assertThat((Object)this.pathFactory.create("../").isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("../").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.pathFactory.create("../"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
    }

    @Test
    public void shouldConstructRootPathFromStringWithSingleDelimiter() {
        Assert.assertThat((Object)this.pathFactory.create("/"), (Matcher)Is.is((Object)ROOT));
        Assert.assertThat((Object)this.pathFactory.create("/").isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotConstructPathWithSuccessiveDelimiters() {
        this.pathFactory.create("///a/b///c//d//");
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotConstructPathWithOnlyDelimiters() {
        this.pathFactory.create("///");
    }

    @Test
    public void shouldConstructPathFromStringAndShouldIgnoreLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.pathFactory.create(" \t /  \t").toString(), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldConstructRelativePathIfSuppliedPathHasNoLeadingDelimiter() {
        Assert.assertThat((Object)this.pathFactory.create("a"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a"));
    }

    @Test
    public void shouldHaveSizeThatReflectsNumberOfSegments() {
        Assert.assertThat((Object)this.path.size(), (Matcher)Is.is((Object)this.validSegmentsList.size()));
    }

    @Test
    public void shouldIterateOverAllSegmentsReturnedByList() {
        Iterator<Object> expectedIter = this.validSegmentsList.iterator();
        for (Path.Segment segment : this.path) {
            Assert.assertThat((Object)segment, (Matcher)Is.is((Object)expectedIter.next()));
        }
        expectedIter = this.path.getSegmentsList().iterator();
        for (Path.Segment segment : this.path) {
            Assert.assertThat((Object)segment, (Matcher)Is.is((Object)expectedIter.next()));
        }
    }

    @Test
    public void shouldReturnAncestorForNodeOtherThanRoot() {
        Assert.assertThat((Object)this.path.getParent(), (Matcher)Is.is((Object)this.pathFactory.create("/mode:a/mode:b")));
        Assert.assertThat((Object)this.path.getParent().getParent(), (Matcher)Is.is((Object)this.pathFactory.create("/mode:a")));
        Assert.assertThat((Object)this.path.getParent().getParent().getParent(), (Matcher)Is.is((Object)ROOT));
    }

    @Test
    public void shouldReturnNthDegreeAncestor() {
        Assert.assertThat((Object)this.path.getAncestor(1), (Matcher)Is.is((Object)this.pathFactory.create("/mode:a/mode:b")));
        Assert.assertThat((Object)this.path.getAncestor(2), (Matcher)Is.is((Object)this.pathFactory.create("/mode:a")));
        Assert.assertThat((Object)this.path.getAncestor(3), (Matcher)Is.is((Object)ROOT));
    }

    @Test
    public void shouldConsiderRootTheLowestCommonAncestorOfAnyNodeAndRoot() {
        Assert.assertThat((Object)this.path.getCommonAncestor(ROOT), (Matcher)Is.is((Object)ROOT));
        Assert.assertThat((Object)ROOT.getCommonAncestor(this.path), (Matcher)Is.is((Object)ROOT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldReturnNullForLowestCommonAncestorWithNullPath() {
        this.path.getCommonAncestor(null);
    }

    @Test
    public void shouldFindLowestCommonAncestorBetweenTwoNonRootNodesOnCommonBranch() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)path1.getCommonAncestor(path2), (Matcher)Is.is((Object)common));
        path1 = this.pathFactory.create("/a/b/c");
        path2 = this.pathFactory.create("/a/b/c/d");
        common = path1;
        Assert.assertThat((Object)path1.getCommonAncestor(path2), (Matcher)Is.is((Object)common));
        path1 = this.pathFactory.create("/a/b/c/x/y/");
        path2 = this.pathFactory.create("/a/b/c/d/e/f/");
        common = this.pathFactory.create("/a/b/c");
        Assert.assertThat((Object)path1.getCommonAncestor(path2), (Matcher)Is.is((Object)common));
    }

    @Test
    public void shouldConsiderRootTheLowestCommonAncestorOfAnyNodesOnSeparateBrances() {
        Path path1 = this.pathFactory.create("/x/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path common = ROOT;
        Assert.assertThat((Object)path1.getCommonAncestor(path2), (Matcher)Is.is((Object)common));
    }

    @Test
    public void shouldConsiderNodeToBeAncestorOfEveryDecendantNode() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)common.isAncestorOf(path1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)common.isAncestorOf(path2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)common.isAncestorOf(path3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path1.getParent().isAncestorOf(path1), (Matcher)Is.is((Object)true));
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAncestorOf(path1), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAncestorOf(path2), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAncestorOf(path3), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAncestorOf(path4), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldConsiderNodeToBeDecendantOfEveryAncestorNode() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)path1.isDecendantOf(common), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)path2.isDecendantOf(common), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)path3.isDecendantOf(common), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path1.getParent().isAncestorOf(path1), (Matcher)Is.is((Object)true));
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isDecendantOf(path1.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isDecendantOf(path2.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isDecendantOf(path3.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isDecendantOf(path4.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldNotConsiderNodeToBeAncestorOfItself() {
        super.shouldNotConsiderNodeToBeAncestorOfItself();
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Assert.assertThat((Object)path1.isAncestorOf(path1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path2.isAncestorOf(path2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path3.isAncestorOf(path3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ROOT.isAncestorOf(ROOT), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotConsiderNodeToBeDecendantOfItself() {
        super.shouldNotConsiderNodeToBeDecendantOfItself();
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Assert.assertThat((Object)path1.isDecendantOf(path1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path2.isDecendantOf(path2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)path3.isDecendantOf(path3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ROOT.isDecendantOf(ROOT), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotConsiderRootToBeDecendantOfAnyNode() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)ROOT.isDecendantOf(path1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ROOT.isDecendantOf(path2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ROOT.isDecendantOf(path3), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ROOT.isDecendantOf(common), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderRootToBeAncestorOfAnyNode() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)ROOT.isAncestorOf(path1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)ROOT.isAncestorOf(path2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)ROOT.isAncestorOf(path3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)ROOT.isAncestorOf(common), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderTwoNotRootSiblingNodesToHaveSameAncestor() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/y/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)true));
        path1 = this.pathFactory.create("/a/z");
        path2 = this.pathFactory.create("/a/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)true));
        path1 = this.pathFactory.create("/z");
        path2 = this.pathFactory.create("/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotConsiderTwoNonSiblingNodesToHaveSameAncestor() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/x/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)false));
        path1 = this.pathFactory.create("/a/z");
        path2 = this.pathFactory.create("/b/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)false));
        path1 = this.pathFactory.create("/z");
        path2 = this.pathFactory.create("/a/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderAncestorToBeAtOrAboveTheDecendant() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAtOrAbove(path1), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAtOrAbove(path2), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAtOrAbove(path3), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAtOrAbove(path4), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldConsiderDecendantToBeAtOrBelowTheAncestor() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isAtOrBelow(path1.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isAtOrBelow(path2.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isAtOrBelow(path3.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isAtOrBelow(path4.getAncestor(i)), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldNotConsiderAncestorToBeAtOrBelowTheDecendant() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAtOrBelow(path1), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAtOrBelow(path2), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAtOrBelow(path3), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAtOrBelow(path4), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldNotConsiderDecendantToBeAtOrAboveTheAncestor() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isAtOrAbove(path1.getAncestor(i)), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isAtOrAbove(path2.getAncestor(i)), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isAtOrAbove(path3.getAncestor(i)), (Matcher)Is.is((Object)false));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isAtOrAbove(path4.getAncestor(i)), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldReturnLastSegmentOfNonRootPath() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x");
        Assert.assertThat((Object)path1.getLastSegment().getName().getLocalName(), (Matcher)Is.is((Object)"z"));
        Assert.assertThat((Object)path2.getLastSegment().getName().getLocalName(), (Matcher)Is.is((Object)"c"));
        Assert.assertThat((Object)path3.getLastSegment().getName().getLocalName(), (Matcher)Is.is((Object)"c"));
        Assert.assertThat((Object)path4.getLastSegment().getName().getLocalName(), (Matcher)Is.is((Object)"x"));
    }

    @Test
    public void shouldNormalizePathWithSelfAndParentReferences() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), (Matcher)Is.is((Object)true));
        this.path = this.pathFactory.create("a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAlreadyBeNormalizedIfPathContainsNoParentOrSelfReferences() {
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/d/e").isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/d/e").isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pathFactory.create("a").isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.pathFactory.create("/a").isNormalized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)ROOT.isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeNormalizedIfPathContainsParentOrSelfReferences() {
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/../d/./e/../..").isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/../d/./e/../..").isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/./d").isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/../d").isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create(".").isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.pathFactory.create("/.").isNormalized(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldFailToReturnNormalizedPathIfPathContainsReferencesToParentsAboveRoot() {
        this.path = this.pathFactory.create("/a/../../../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        this.path.getNormalizedPath();
    }

    @Test
    public void shouldReturnRootPathAsTheNormalizedPathForAnAbsolutePathWithZeroSegmentsAfterParentAndSelfReferencesRemoved() {
        this.path = this.pathFactory.create("/a/../b/../c/../");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), (Matcher)Is.is((Object)ROOT));
    }

    @Test
    public void shouldReturnSelfPathAsTheNormalizedPathForARelativePathWithZeroSegmentsAfterParentAndSelfReferencesRemoved() {
        this.path = this.pathFactory.create("a/../b/../c/../");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
    }

    @Test
    public void shouldNotHaveAnyParentOrSelfReferencesInTheNormalizedPathOfAnAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotHaveAnyParentReferencesInTheNormalizedPathOfARelativePath() {
        this.path = this.pathFactory.create("a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotComputeCanonicalPathOfNodeThatIsNotAbsolute() {
        this.pathFactory.create("a/b/c/../d/./e/../..").getCanonicalPath();
    }

    @Test
    public void shouldReturnNormalizedPathForTheCanonicalPathOfAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.path.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getCanonicalPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getCanonicalPath().isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path.getCanonicalPath().isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldReturnSameSegmentsInIteratorAndArrayAndList() {
        this.testSegmentsByIteratorAndListAndArray("/a/b/c/../d/./e/../..", "a", "b", "c", "..", "d", ".", "e", "..", "..");
        this.testSegmentsByIteratorAndListAndArray("/a/b/c", "a", "b", "c");
        this.testSegmentsByIteratorAndListAndArray("a/b/c/../d/./e/../..", "a", "b", "c", "..", "d", ".", "e", "..", "..");
        this.testSegmentsByIteratorAndListAndArray("a/b/c", "a", "b", "c");
        this.testSegmentsByIteratorAndListAndArray("", new String[0]);
        this.testSegmentsByIteratorAndListAndArray(ROOT.getString(), new String[0]);
    }

    public void testSegmentsByIteratorAndListAndArray(String pathStr, String ... expectedSegmentStrings) {
        this.path = this.pathFactory.create(pathStr);
        Assert.assertThat((Object)expectedSegmentStrings.length, (Matcher)Is.is((Object)this.path.size()));
        Path.Segment[] segmentArray = this.path.getSegmentsArray();
        List segmentList = this.path.getSegmentsList();
        Assert.assertThat((Object)segmentArray.length, (Matcher)Is.is((Object)this.path.size()));
        Assert.assertThat((Object)segmentList.size(), (Matcher)Is.is((Object)this.path.size()));
        Iterator iter = this.path.iterator();
        Iterator listIter = segmentList.iterator();
        for (int i = 0; i != this.path.size(); ++i) {
            Path.Segment expected = this.pathFactory.createSegment(expectedSegmentStrings[i]);
            Assert.assertThat((Object)this.path.getSegment(i), (Matcher)Is.is((Object)expected));
            Assert.assertThat((Object)segmentArray[i], (Matcher)Is.is((Object)expected));
            Assert.assertThat(segmentList.get(i), (Matcher)Is.is((Object)expected));
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)expected));
            Assert.assertThat(listIter.next(), (Matcher)Is.is((Object)expected));
        }
        Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)listIter.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldGetStringWithNamespaceUrisIfNoNamespaceRegistryIsProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.getString(NO_OP_ENCODER), (Matcher)Is.is((Object)"/{http://www.modeshape.org/1.0}a/{}b/{http://www.modeshape.org/1.0}c/../{}d/./{http://www.modeshape.org/1.0}e/../.."));
    }

    @Test
    public void shouldGetStringWithNamespacePrefixesForAllNamesIfNamespaceRegistryIsProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.getString(this.namespaceRegistry, NO_OP_ENCODER), (Matcher)Is.is((Object)"/mode:a/b/mode:c/../d/./mode:e/../.."));
        this.namespaceRegistry.register("dna2", this.validNamespaceUri);
        Assert.assertThat((Object)this.path.getString(this.namespaceRegistry, NO_OP_ENCODER), (Matcher)Is.is((Object)"/dna2:a/b/dna2:c/../d/./dna2:e/../.."));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnSubpathIfStartingIndexIsNegative() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathWithoutEndingIndexIfStartingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(this.path.size() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathWithEndingIndexIfStartingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(this.path.size() + 1, this.path.size() + 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathIfEndingIndexIsSmallerThanStartingIndex() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(2, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathIfEndingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(2, this.path.size() + 1);
    }

    @Test
    public void shouldReturnRootAsSubpathIfStartingIndexAndEndingIndexAreBothZero() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0, 0), (Matcher)Is.is((Object)ROOT));
    }

    @Test
    public void shouldReturnSubpathIfValidStartingIndexAndNoEndingIndexAreProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0), (Matcher)Is.is((Object)this.path));
        Assert.assertThat((Object)this.path.subpath(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
        Assert.assertThat((Object)this.path.subpath(1), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        this.path = this.pathFactory.create("mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0), (Matcher)Is.is((Object)this.path));
        Assert.assertThat((Object)this.path.subpath(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
        Assert.assertThat((Object)this.path.subpath(1), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
    }

    @Test
    public void shouldReturnSubpathIfValidStartingIndexAndEndingIndexAreProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), (Matcher)Is.is((Object)this.path));
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
        Assert.assertThat((Object)this.path.subpath(1, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        Assert.assertThat((Object)this.path.subpath(0, 2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b"));
        Assert.assertThat((Object)this.path.subpath(1, 2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b"));
        Assert.assertThat((Object)this.path.subpath(1, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d"));
        Assert.assertThat((Object)this.path.subpath(2, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d"));
        Assert.assertThat((Object)this.path.subpath(3, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d"));
    }

    @Test
    public void shouldFindRelativePaths() {
        this.path = this.pathFactory.create("/a/b/c/d");
        Assert.assertThat((Object)this.path.relativeTo(this.pathFactory.create("/a/e/f")), (Matcher)Is.is((Object)this.pathFactory.create("../../b/c/d")));
        Assert.assertThat((Object)this.path.relativeTo(this.pathFactory.create("/e/f")), (Matcher)Is.is((Object)this.pathFactory.create("../../a/b/c/d")));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotAllowFindingRelativePathsFromRelativePaths() {
        this.path = this.pathFactory.create("a/b/c/d");
        this.path.relativeTo(this.pathFactory.create("/e/f"));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathToAnotherRelativePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path.relativeTo(this.pathFactory.create("e/f"));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathUsingAnAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path.resolve(this.pathFactory.create("/e/f"));
    }

    @Test
    public void shouldResolveRelativePathToAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path2 = this.path.resolve(this.pathFactory.create("../../e/f"));
        Assert.assertThat((Object)this.path2, (Matcher)Is.is((Object)this.pathFactory.create("/a/b/e/f")));
        Assert.assertThat((Object)this.path2.isAbsolute(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.path2.isNormalized(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOrderPathsCorrectly() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.pathFactory.create("/a"));
        paths.add(this.pathFactory.create("/a/b"));
        paths.add(this.pathFactory.create("/a/b/alpha"));
        paths.add(this.pathFactory.create("/a/b/beta"));
        paths.add(this.pathFactory.create("/a/b/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/b/mode:name"));
        paths.add(this.pathFactory.create("/a/b/mode:primaryType"));
        paths.add(this.pathFactory.create("/a/c[1]"));
        paths.add(this.pathFactory.create("/a/c[1]/alpha"));
        paths.add(this.pathFactory.create("/a/c[1]/beta"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:name"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:primaryType"));
        paths.add(this.pathFactory.create("/a/c[2]"));
        paths.add(this.pathFactory.create("/a/c[2]/alpha"));
        paths.add(this.pathFactory.create("/a/c[2]/beta"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:name"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:primaryType"));
        ArrayList randomizedPaths = new ArrayList(paths);
        Collections.shuffle(randomizedPaths);
        Assert.assertThat(randomizedPaths, (Matcher)Is.is((Matcher)IsNot.not(paths)));
        Collections.sort(randomizedPaths);
        Assert.assertThat(randomizedPaths, (Matcher)Is.is(paths));
    }

    @Test
    public void shouldGetNormalizedPathOfSelfShouldBeSame() {
        Assert.assertThat((Object)this.pathFactory.create(".").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create(".")));
        Assert.assertThat((Object)this.pathFactory.create("./").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create(".")));
        Assert.assertThat((Object)this.pathFactory.create("./././").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create(".")));
    }

    @Test
    public void shouldGetNormalizedPathWithParentReferences() {
        Assert.assertThat((Object)this.pathFactory.create("..").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create("..")));
        Assert.assertThat((Object)this.pathFactory.create("../").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create("../")));
        Assert.assertThat((Object)this.pathFactory.create("../../../../../..").getNormalizedPath(), (Matcher)Is.is((Object)this.pathFactory.create("../../../../../..")));
    }

    @Test
    public void shouldGetRelativePathUsingSelf() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create(".")), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("././.")), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.path)));
    }

    @Test
    public void shouldResolveRelativePathToParent() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("..")), (Matcher)Is.is((Object)this.path.getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e"));
    }

    @Test
    public void shouldResolveRelativePaths() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../../../../../..")), (Matcher)Is.is((Object)ROOT));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../..")), (Matcher)Is.is((Object)this.path.getParent().getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d"));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x/../y/../z/..")), (Matcher)Is.is((Object)this.path.getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x/../y/../z/..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e"));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e", "x"));
    }

    @Test
    public void shouldResolveNonAbsolutePaths() {
        this.path = this.pathFactory.create("a/b/c");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c"));
    }

    @Test
    public void shouldConsiderTwoEquivalentPathsEqual() {
        Path path1 = this.pathFactory.create("/a/b/c");
        Path path2 = this.pathFactory.create("/a/b/c");
        Assert.assertThat((Object)path1.equals(path2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldConsiderTwoDifferentPathsNotEqual() {
        Path path1 = this.pathFactory.create("/a/b/c");
        Path path2 = this.pathFactory.create("/a/b/d");
        Assert.assertThat((Object)path1.equals(path2), (Matcher)Is.is((Object)false));
        path2 = this.pathFactory.create("/a/b");
        Assert.assertThat((Object)path1.equals(path2), (Matcher)Is.is((Object)false));
        path2 = this.pathFactory.create("/a/b/c[2]");
        Assert.assertThat((Object)path1.equals(path2), (Matcher)Is.is((Object)false));
        path2 = this.pathFactory.create("/a/b/c/c");
        Assert.assertThat((Object)path1.equals(path2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConvertPathToString() {
        Jsr283Encoder encoder = new Jsr283Encoder();
        TextEncoder delimEncoder = new TextEncoder(){

            public String encode(String text) {
                if ("/".equals(text)) {
                    return "\\/";
                }
                if (":".equals(text)) {
                    return "\\:";
                }
                if ("{".equals(text)) {
                    return "\\{";
                }
                if ("}".equals(text)) {
                    return "\\}";
                }
                return text;
            }
        };
        Path path = this.pathFactory.create("a/b/c");
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), (Matcher)Is.is((Object)"a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), (Matcher)Is.is((Object)"a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), (Matcher)Is.is((Object)"a\\/b\\/c"));
        path = this.pathFactory.create("/a/b/c");
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), (Matcher)Is.is((Object)"/a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), (Matcher)Is.is((Object)"\\/a\\/b\\/c"));
        path = this.pathFactory.create("/mode:a/b/c");
        Assert.assertThat((Object)path.getString((TextEncoder)encoder), (Matcher)Is.is((Object)("/{" + encoder.encode("http://www.modeshape.org/1.0") + "}a/{}b/{}c")));
        Assert.assertThat((Object)path.getString(null, (TextEncoder)encoder, delimEncoder), (Matcher)Is.is((Object)("\\/\\{" + encoder.encode("http://www.modeshape.org/1.0") + "\\}a\\/\\{\\}b\\/\\{\\}c")));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), (Matcher)Is.is((Object)"/mode:a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), (Matcher)Is.is((Object)"/mode:a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), (Matcher)Is.is((Object)"\\/mode\\:a\\/b\\/c"));
    }
}

