/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.StringMatcher;
import org.modeshape.graph.property.basic.JodaDateTime;

public class JodaDateTimeTest {
    private JodaDateTime instant;
    private String iso8601instance;

    @Before
    public void setUp() throws Exception {
        this.iso8601instance = "2008-05-10T13:22:04.678";
    }

    @Test
    public void shouldConstructWithIso8601FormattedStringWithoutZone() {
        this.instant = new JodaDateTime(this.iso8601instance, "UTC");
        Assert.assertThat((Object)this.instant.getString(), (Matcher)StringMatcher.startsWith((String)this.iso8601instance));
        Assert.assertThat((Object)this.instant.getYearOfCentury(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)this.instant.getYear(), (Matcher)Is.is((Object)2008));
        Assert.assertThat((Object)this.instant.getMonthOfYear(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)this.instant.getDayOfMonth(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.instant.getDayOfWeek(), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)this.instant.getHourOfDay(), (Matcher)Is.is((Object)13));
        Assert.assertThat((Object)this.instant.getMinuteOfHour(), (Matcher)Is.is((Object)22));
        Assert.assertThat((Object)this.instant.getSecondOfMinute(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.instant.getMillisOfSecond(), (Matcher)Is.is((Object)678));
        Assert.assertThat((Object)this.instant.getTimeZoneId(), (Matcher)Is.is((Object)"UTC"));
        Assert.assertThat((Object)this.instant.getTimeZoneOffsetHours(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldConstructWithIso8601FormattedString() {
        this.iso8601instance = "2008-05-10T13:22:04.678-04:00";
        this.instant = new JodaDateTime(this.iso8601instance);
        this.instant = (JodaDateTime)this.instant.toTimeZone("UTC");
        Assert.assertThat((Object)this.instant.getString(), (Matcher)Is.is((Object)"2008-05-10T17:22:04.678Z"));
        Assert.assertThat((Object)this.instant.getYearOfCentury(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)this.instant.getYear(), (Matcher)Is.is((Object)2008));
        Assert.assertThat((Object)this.instant.getMonthOfYear(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)this.instant.getDayOfMonth(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.instant.getDayOfWeek(), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)this.instant.getHourOfDay(), (Matcher)Is.is((Object)17));
        Assert.assertThat((Object)this.instant.getMinuteOfHour(), (Matcher)Is.is((Object)22));
        Assert.assertThat((Object)this.instant.getSecondOfMinute(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.instant.getMillisOfSecond(), (Matcher)Is.is((Object)678));
        Assert.assertThat((Object)this.instant.getTimeZoneId(), (Matcher)Is.is((Object)"UTC"));
        Assert.assertThat((Object)this.instant.getTimeZoneOffsetHours(), (Matcher)Is.is((Object)0));
    }
}

