/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableKey
implements Schemata.Key {
    private final Set<Schemata.Column> columns;

    protected ImmutableKey(Iterable<Schemata.Column> columns) {
        assert (columns != null);
        HashSet<Schemata.Column> columnSet = new HashSet<Schemata.Column>();
        for (Schemata.Column column : columns) {
            if (column == null) continue;
            columnSet.add(column);
        }
        assert (!columnSet.isEmpty());
        this.columns = Collections.unmodifiableSet(columnSet);
    }

    protected ImmutableKey(Schemata.Column ... columns) {
        assert (columns != null);
        assert (columns.length > 0);
        HashSet<Schemata.Column> columnSet = new HashSet<Schemata.Column>();
        for (Schemata.Column column : columns) {
            if (column == null) continue;
            columnSet.add(column);
        }
        assert (!columnSet.isEmpty());
        this.columns = Collections.unmodifiableSet(columnSet);
    }

    @Override
    public Set<Schemata.Column> getColumns() {
        return this.columns;
    }

    @Override
    public boolean hasColumns(Schemata.Column ... columns) {
        HashSet<Schemata.Column> keyColumns = new HashSet<Schemata.Column>(this.columns);
        for (Schemata.Column expected : columns) {
            if (keyColumns.remove(expected)) continue;
            return false;
        }
        return keyColumns.isEmpty();
    }

    @Override
    public boolean hasColumns(Iterable<Schemata.Column> columns) {
        HashSet<Schemata.Column> keyColumns = new HashSet<Schemata.Column>(this.columns);
        for (Schemata.Column expected : columns) {
            if (keyColumns.remove(expected)) continue;
            return false;
        }
        return keyColumns.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (Schemata.Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(']');
        return sb.toString();
    }
}

