/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.collection.Collections;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;

public class ConfigurationTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas((String)"security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() {
        this.configuration = new JcrConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadFederatingConfig() throws Exception {
        String[] workspaceNames;
        File file = new File("src/test/resources/config/federatingConfigRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        Assert.assertThat((Object)this.configuration.repository("magnolia").getSource(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("magnolia").getName(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("disk").getName(), (Matcher)Is.is((Object)"disk"));
        Assert.assertThat((Object)this.configuration.repositorySource("data").getName(), (Matcher)Is.is((Object)"data"));
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("magnolia");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Set magnoliaWorkspaces = this.engine.getGraph("magnolia").getWorkspaces();
        Set diskWorkspaces = this.engine.getGraph("disk").getWorkspaces();
        Set dataWorkspaces = this.engine.getGraph("data").getWorkspaces();
        Assert.assertThat((Object)magnoliaWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
        Assert.assertThat((Object)dataWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "modeSystem"})));
        Assert.assertThat((Object)diskWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"workspace1"})));
        Session session = null;
        SimpleCredentials credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        for (String workspaceName : workspaceNames = new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"}) {
            try {
                session = repository.login((Credentials)credentials, workspaceName);
                session.getRootNode().addNode("testNode", "nt:folder");
                Set jcrWorkspaces = Collections.unmodifiableSet((Object[])session.getWorkspace().getAccessibleWorkspaceNames());
                Assert.assertThat((Object)jcrWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateInMemoryRepository() throws Exception {
        String[] workspaceNames;
        File file = new File("src/test/resources/config/federatingConfigRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        Assert.assertThat((Object)this.configuration.repository("magnolia").getSource(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("magnolia").getName(), (Matcher)Is.is((Object)"magnolia"));
        Assert.assertThat((Object)this.configuration.repositorySource("disk").getName(), (Matcher)Is.is((Object)"disk"));
        Assert.assertThat((Object)this.configuration.repositorySource("data").getName(), (Matcher)Is.is((Object)"data"));
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("data");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Set magnoliaWorkspaces = this.engine.getGraph("magnolia").getWorkspaces();
        Set diskWorkspaces = this.engine.getGraph("disk").getWorkspaces();
        Set dataWorkspaces = this.engine.getGraph("data").getWorkspaces();
        Assert.assertThat((Object)magnoliaWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "downloads"})));
        Assert.assertThat((Object)dataWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion", "modeSystem"})));
        Assert.assertThat((Object)diskWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"workspace1"})));
        Session session = null;
        SimpleCredentials credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        for (String workspaceName : workspaceNames = new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion"}) {
            try {
                session = repository.login((Credentials)credentials, workspaceName);
                session.getRootNode().addNode("testNode", "nt:folder");
                Set jcrWorkspaces = Collections.unmodifiableSet((Object[])session.getWorkspace().getAccessibleWorkspaceNames());
                Assert.assertThat((Object)jcrWorkspaces, (Matcher)Is.is((Object)Collections.unmodifiableSet((Object[])new String[]{"config", "website", "users", "userroles", "usergroups", "mgnlSystem", "mgnlVersion"})));
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @Test
    public void shouldWork() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("My repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldWork2() throws Exception {
        File file = new File("src/test/resources/config/configRepositoryForBrix.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(file);
        this.engine = this.configuration.build();
        this.engine.start();
        JcrRepository repository = this.engine.getRepository("Brix repository");
        Assert.assertThat((Object)repository, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }
}

