/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrOnFileSystemTest {
    private static final String SOURCE_NAME = "Source";
    private static final String REPO_NAME = "Repository";
    private static final String STORAGE_PATH = "./target/scratch";
    private static final String EXCLUSION_PATTERN = ".*mode";
    private JcrEngine engine;
    private Session session;
    private ValueFactory vf;
    private File scratchSpace;

    @Before
    public void beforeEach() throws Exception {
        this.scratchSpace = new File(STORAGE_PATH);
        if (!this.scratchSpace.exists()) {
            this.scratchSpace.mkdir();
        }
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(SOURCE_NAME).usingClass(FileSystemSource.class)).setProperty("exclusionPattern", EXCLUSION_PATTERN)).setProperty("workspaceRootPath", STORAGE_PATH)).setProperty("defaultWorkspaceName", "default")).setProperty("updatesAllowed", true);
        config.repository(REPO_NAME).setSource(SOURCE_NAME).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "readwrite");
        this.engine = config.build();
        this.engine.start();
        if (this.engine.getProblems().hasProblems()) {
            for (Problem problem : this.engine.getProblems()) {
                System.err.println(problem.getMessageString());
            }
        }
        JcrRepository repo = this.engine.getRepository(REPO_NAME);
        this.session = repo.login("default");
        this.vf = this.session.getValueFactory();
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        this.engine.shutdownAndAwaitTermination(3L, TimeUnit.SECONDS);
        FileUtil.delete((File)this.scratchSpace);
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-986"})
    public void shouldNotBeAbleToCreateFileWithFilteredName() throws Exception {
        Node root = this.session.getRootNode();
        Node file = root.addNode("createfile.mode", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", this.vf.createBinary((InputStream)new ByteArrayInputStream("Write 1".getBytes())));
        this.session.save();
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-986"})
    public void shouldNotBeAbleToRenameToFileWithFilteredName() throws Exception {
        Node root = this.session.getRootNode();
        Node file = root.addNode("moveSource.txt", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", this.vf.createBinary((InputStream)new ByteArrayInputStream("Write 1".getBytes())));
        this.session.save();
        this.session.move("/moveSource.txt", "/createfile.mode");
        this.session.save();
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-986"})
    public void shouldNotBeAbleToCopyToFileWithFilteredName() throws Exception {
        Node root = this.session.getRootNode();
        Node file = root.addNode("copySource.txt", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", this.vf.createBinary((InputStream)new ByteArrayInputStream("Write 1".getBytes())));
        this.session.save();
        this.session.getWorkspace().copy("/copySource.txt", "/createfile.mode");
        this.session.save();
    }

    @Test
    @FixFor(value={"MODE-1010"})
    public void shouldAllowFileRenameThroughJcr() throws Exception {
        Node root = this.session.getRootNode();
        root.addNode("oldname", "nt:folder");
        this.session.save();
        File oldFile = new File(STORAGE_PATH + File.separator + "default" + File.separator + "oldname");
        Assert.assertTrue((boolean)oldFile.exists());
        this.session.move("/oldname", "/newname1");
        this.session.save();
        File newFile = new File(STORAGE_PATH + File.separator + "default" + File.separator + "newname1");
        Assert.assertTrue((boolean)newFile.exists());
    }
}

