/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.performance;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.test.ModeShapeSingleUseTest;
import org.modeshape.test.ModeShapeUnitTest;

public class JcrRepositoryPerformanceTest
extends ModeShapeSingleUseTest {
    private static final int NUMBER_OF_COPIES = 150;
    private boolean printDetail = false;

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.printDetail = false;
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    public void shouldSimulateGuvnorUsageAgainstRepositoryWithInMemoryStore() throws Exception {
        this.print = true;
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.simulateGuvnorUsage(5);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    public void shouldSimulateGuvnorUsageAgainstRepositoryWithJpaStore() throws Exception {
        this.print = true;
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.simulateGuvnorUsage(4);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1113"})
    public void shouldHaveImportContentAvailableAfterRestart() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml");
        this.session().refresh(false);
        this.printSubgraph(this.assertNode("/drools:repository"));
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        JcrRepositoryPerformanceTest.stopEngine();
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaNoNodeTypes.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        this.printSubgraph(this.assertNode("/drools:repository"));
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsNewContent() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 0;
        for (int i = 0; i != 3; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        }
        this.simulateGuvnorUsage(1);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsNewContentUsingJpa() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 0;
        for (int i = 0; i != 3; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        }
        this.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsReplacedContent() throws Exception {
        this.print = true;
        this.printDetail = false;
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        for (int i = 0; i != 2; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        }
        this.simulateGuvnorUsage(1);
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportMultipleTimesAsReplacedContentUsingJpa() throws Exception {
        this.print = true;
        this.printDetail = false;
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        for (int i = 0; i != 2; ++i) {
            JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
            this.session().refresh(false);
            this.assertNode("/drools:repository");
            this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        }
        this.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportOnceAndSimulateGuvnorUsage() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportOnceAndSimulateGuvnorUsageUsingJpa() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.simulateGuvnorUsage(1);
    }

    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportAndSimulateGuvnorUsageTwice() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsInMemoryPerformance.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.simulateGuvnorUsage(2);
        this.withSession((ModeShapeUnitTest.Operation)new PrintVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
        this.session().refresh(false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.withSession((ModeShapeUnitTest.Operation)new PrintVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
        this.simulateGuvnorUsage(1);
        this.withSession((ModeShapeUnitTest.Operation)new PrintVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
    }

    @Ignore(value="Removed from automatic builds due to time of test. Can be run manually.")
    @Test
    @FixFor(value={"MODE-1114"})
    public void shouldImportAndSimulateGuvnorUsageTwiceUsingJpa() throws Exception {
        JcrRepositoryPerformanceTest.startEngineUsing((String)"config/configRepositoryForDroolsJpaCreate.xml");
        this.sessionTo("Repo");
        this.assertNode("/", "mode:root", new String[0]);
        int importBehavior = 2;
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.withSession((ModeShapeUnitTest.Operation)new PrintVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
        this.session().refresh(false);
        JcrRepositoryPerformanceTest.importContent(((Object)((Object)this)).getClass(), (String)"io/drools/mortgage-sample-repository.xml", (int)importBehavior);
        this.session().refresh(false);
        this.assertNode("/drools:repository");
        this.withSession((ModeShapeUnitTest.Operation)new VerifyContent());
        this.withSession((ModeShapeUnitTest.Operation)new PrintVersionHistory("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
        this.simulateGuvnorUsage(1);
    }

    protected void simulateGuvnorUsage(int count) throws Exception {
        Assert.assertThat((Object)(count >= 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        Stopwatch sw = new Stopwatch(false, "Iteration");
        Stopwatch total = new Stopwatch(true, "Total usage");
        Stopwatch sw15 = new Stopwatch(true, "First 150");
        Stopwatch swRest = new Stopwatch(true, "Remaining");
        for (int i = 0; i != count; ++i) {
            sw.start();
            total.start();
            if (i <= 150) {
                sw15.start();
            } else {
                swRest.start();
            }
            this.browseTo("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl");
            this.repeatedlyWithSession(1, (ModeShapeUnitTest.Operation)new ModifyAsset("/drools:repository/drools:package_area/mortgages/assets/ApplicantDsl"));
            this.browseTo("/drools:repository/drools:package_area/mortgages");
            ViewContent viewContent = new ViewContent("/drools:repository/drools:package_area/mortgages");
            this.withSession((ModeShapeUnitTest.Operation)viewContent);
            this.printDetail(viewContent.getContent());
            this.withSession((ModeShapeUnitTest.Operation)new BuildPackage("mortgages"));
            String snapshotName = i <= 150 ? "TEST" + i : "TEST15";
            this.withSession((ModeShapeUnitTest.Operation)new CreatePackageSnapshot("mortgages", snapshotName, "My TEST snapshot"));
            this.withSession((ModeShapeUnitTest.Operation)new LoadPackageSnapshot("mortgages", snapshotName));
            sw.stop();
            total.stop();
            if (i <= 150) {
                sw15.stop();
            } else {
                swRest.stop();
            }
            this.print(StringUtil.justifyRight((String)("" + i), (int)3, (char)' ') + " " + sw);
            sw.reset();
        }
        if (sw15.getCount() != total.getCount()) {
            this.print(sw15);
        }
        if (swRest.getCount() > 0) {
            this.print(swRest);
        }
        this.print(total);
    }

    protected void printDetail(Object msg) {
        if (this.printDetail && msg != null) {
            System.out.println(msg.toString());
        }
    }

    public abstract class DroolsOperation
    extends ModeShapeUnitTest.BasicOperation {
        public static final String TITLE_PROPERTY_NAME = "drools:title";
        public static final String DESCRIPTION_PROPERTY_NAME = "drools:description";
        public static final String LAST_MODIFIED_PROPERTY_NAME = "drools:lastModified";
        public static final String FORMAT_PROPERTY_NAME = "drools:format";
        public static final String CHECKIN_COMMENT = "drools:checkinComment";
        public static final String VERSION_NUMBER_PROPERTY_NAME = "drools:versionNumber";
        public static final String CONTENT_PROPERTY_ARCHIVE_FLAG = "drools:archive";
        public static final String LAST_CONTRIBUTOR_PROPERTY_NAME = "drools:lastContributor";
        public static final String CONTENT_PROPERTY_NAME = "drools:content";
        public static final String CONTENT_PROPERTY_BINARY_NAME = "drools:binaryContent";
        public static final String CONTENT_PROPERTY_ATTACHMENT_FILENAME = "drools:attachmentFileName";
        public static final String PACKAGE_AREA = "drools:package_area";
        public static final String PACKAGE_SNAPSHOT_AREA = "drools:packagesnapshot_area";
        public static final String ASSET_FOLDER_NAME = "assets";

        public DroolsOperation() {
            super((ModeShapeUnitTest)JcrRepositoryPerformanceTest.this);
        }

        public VersionManager versionMgr(Node versionable) throws RepositoryException {
            return versionable.getSession().getWorkspace().getVersionManager();
        }

        public void checkout(Node versionable) throws RepositoryException {
            this.versionMgr(versionable).checkout(versionable.getPath());
        }

        public void checkin(Node versionable, String comment) throws RepositoryException {
            versionable.setProperty(LAST_MODIFIED_PROPERTY_NAME, Calendar.getInstance());
            this.updateCheckinComment(versionable, comment);
            versionable.setProperty(LAST_CONTRIBUTOR_PROPERTY_NAME, versionable.getSession().getUserID());
            long nextVersion = this.versionNumber(versionable) + 1L;
            versionable.setProperty(VERSION_NUMBER_PROPERTY_NAME, nextVersion);
            versionable.getSession().save();
            this.versionMgr(versionable).checkin(versionable.getPath());
        }

        public void updateCheckinComment(Node versionable, String comment) throws RepositoryException {
            versionable.setProperty(CHECKIN_COMMENT, comment);
        }

        public Calendar lastModified(Node versionable) throws RepositoryException {
            if (versionable.hasProperty(LAST_MODIFIED_PROPERTY_NAME)) {
                Property lastModifiedProperty = versionable.getProperty(LAST_MODIFIED_PROPERTY_NAME);
                return lastModifiedProperty.getDate();
            }
            return null;
        }

        public long versionNumber(Node versionable) throws RepositoryException {
            return this.longProperty(versionable, VERSION_NUMBER_PROPERTY_NAME);
        }

        public long longProperty(Node theNode, String propertyName) throws RepositoryException {
            if (theNode.hasProperty(propertyName)) {
                Property data = theNode.getProperty(propertyName);
                return data.getValue().getLong();
            }
            return 0L;
        }

        public void updateDescription(Node versionable, String newDescriptionContent) throws RepositoryException {
            this.checkout(versionable);
            versionable.setProperty(DESCRIPTION_PROPERTY_NAME, newDescriptionContent);
            Calendar lastModified = Calendar.getInstance();
            versionable.setProperty(LAST_MODIFIED_PROPERTY_NAME, lastModified);
        }

        public boolean isBinary(Node node) throws RepositoryException {
            return node.hasProperty(CONTENT_PROPERTY_BINARY_NAME);
        }

        public boolean isArchived(Node node) throws RepositoryException {
            return node.hasProperty(CONTENT_PROPERTY_ARCHIVE_FLAG);
        }

        public String getAssetFormat(Node node) throws RepositoryException {
            return node.hasProperty(FORMAT_PROPERTY_NAME) ? node.getProperty(FORMAT_PROPERTY_NAME).getString() : null;
        }

        public String readBinaryContentAttachment(Node assetNode) throws RepositoryException, IOException {
            if (assetNode.hasProperty(CONTENT_PROPERTY_BINARY_NAME)) {
                Property data = assetNode.getProperty(CONTENT_PROPERTY_BINARY_NAME);
                return IoUtil.read((InputStream)data.getBinary().getStream());
            }
            if (assetNode.hasProperty(CONTENT_PROPERTY_NAME)) {
                Property data = assetNode.getProperty(CONTENT_PROPERTY_NAME);
                return IoUtil.read((InputStream)data.getBinary().getStream());
            }
            return null;
        }

        public Node area(Session session, String areaName) throws RepositoryException {
            return session.getRootNode().getNode("drools:repository").getNode(areaName);
        }

        public void removePackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            Node snapshotPackage = null;
            if (snapshotArea.hasNode(packageName)) {
                snapshotPackage = snapshotArea.getNode(packageName);
            } else {
                snapshotPackage = snapshotArea.addNode(packageName, "nt:folder");
                session.save();
            }
            if (snapshotPackage.hasNode(snapshotName)) {
                snapshotPackage.getNode(snapshotName).remove();
                session.save();
            }
        }

        public void createPackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            Node snapshotPackage = null;
            if (snapshotArea.hasNode(packageName)) {
                snapshotPackage = snapshotArea.getNode(packageName);
            } else {
                snapshotPackage = snapshotArea.addNode(packageName, "nt:folder");
                session.save();
            }
            if (snapshotPackage.hasNode(snapshotName)) {
                snapshotPackage.getNode(snapshotName).remove();
                session.save();
            }
            String newName = snapshotPackage.getPath() + "/" + snapshotName;
            long start = System.currentTimeMillis();
            session.getWorkspace().copy(packageNode.getPath(), newName);
            JcrRepositoryPerformanceTest.this.printDetail("Time taken for snap: " + (System.currentTimeMillis() - start));
        }

        public Node loadPackageSnapshot(Session session, String packageName, String snapshotName) throws RepositoryException {
            Node snapshotArea = this.area(session, PACKAGE_SNAPSHOT_AREA);
            return snapshotArea.getNode(packageName).getNode(snapshotName);
        }

        public void buildPackage(Session session, String packageName) throws RepositoryException, IOException {
            List<Node> assets = this.listAssets(session, packageName, "function");
            long time = System.currentTimeMillis();
            for (Node assetNode : assets) {
                if (this.isBinary(assetNode)) {
                    this.readBinaryContentAttachment(assetNode);
                    continue;
                }
                if (!assetNode.hasProperty(CONTENT_PROPERTY_NAME)) continue;
                Property data = assetNode.getProperty(CONTENT_PROPERTY_NAME);
                data.getValue().getString();
            }
            List<Node> drls = this.listAssets(session, packageName, "drl");
            for (Node drlNode : drls) {
                if (this.isArchived(drlNode)) continue;
                this.readBinaryContentAttachment(drlNode);
            }
            List<Node> allAssets = this.getPackageAssets(session, packageName);
            for (Node nonDrlNode : allAssets) {
                if ("drl".equals(this.getAssetFormat(nonDrlNode)) || this.isArchived(nonDrlNode)) continue;
                this.readBinaryContentAttachment(nonDrlNode);
            }
            long taken = System.currentTimeMillis() - time;
            JcrRepositoryPerformanceTest.this.printDetail("Package build time is: " + taken);
        }

        public List<Node> listAssets(Session session, String packageName, String format) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            String packagePath = packageNode.getPath();
            String sql = "SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '" + packagePath + "/" + ASSET_FOLDER_NAME + "[%]/%'" + " AND drools:format = '" + format + "' AND drools:archive = 'false' ORDER BY drools:title";
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            long time = System.currentTimeMillis();
            QueryResult res = q.execute();
            NodeIterator it = res.getNodes();
            long taken = System.currentTimeMillis() - time;
            JcrRepositoryPerformanceTest.this.printDetail("Query execution time is: " + taken);
            return this.nodesFrom(it);
        }

        public List<Node> getPackageAssets(Session session, String packageName) throws RepositoryException {
            Node packageNode = this.area(session, PACKAGE_AREA).getNode(packageName);
            NodeIterator iter = packageNode.getNode(ASSET_FOLDER_NAME).getNodes();
            return this.nodesFrom(iter);
        }

        protected List<Node> nodesFrom(NodeIterator iter) {
            ArrayList<Node> result = new ArrayList<Node>();
            while (iter.hasNext()) {
                result.add(iter.nextNode());
            }
            return result;
        }
    }

    protected class BuildPackage
    extends DroolsOperation {
        private String packageName;

        public BuildPackage(String packageName) {
            this.packageName = packageName;
        }

        public void run(Session s) throws RepositoryException, IOException {
            this.buildPackage(s, this.packageName);
            this.getPackageAssets(s, this.packageName);
        }
    }

    protected class LoadPackageSnapshot
    extends DroolsOperation {
        private String packageName;
        private String snapshotName;

        public LoadPackageSnapshot(String packageName, String snapshotName) {
            this.packageName = packageName;
            this.snapshotName = snapshotName;
        }

        public void run(Session s) throws RepositoryException {
            this.loadPackageSnapshot(s, this.packageName, this.snapshotName);
        }
    }

    protected class CreatePackageSnapshot
    extends DroolsOperation {
        private String packageName;
        private String snapshotName;
        private String comment;

        public CreatePackageSnapshot(String packageName, String snapshotName, String comment) {
            this.packageName = packageName;
            this.snapshotName = snapshotName;
            this.comment = comment;
        }

        public void run(Session s) throws RepositoryException {
            this.createPackageSnapshot(s, this.packageName, this.snapshotName);
            Node pkgItem = this.loadPackageSnapshot(s, this.packageName, this.snapshotName);
            if (this.comment != null) {
                this.updateCheckinComment(pkgItem, this.comment);
            }
            s.save();
        }
    }

    protected class PrintVersionHistory
    extends DroolsOperation {
        private String path;

        public PrintVersionHistory(String path) {
            this.path = path;
        }

        public void run(Session s) throws RepositoryException {
            Node assetNode = s.getNode(this.path);
            VersionManager vmgr = s.getWorkspace().getVersionManager();
            VersionHistory versionHistory = vmgr.getVersionHistory(this.path);
            if (JcrRepositoryPerformanceTest.this.print) {
                JcrRepositoryPerformanceTest.this.print("");
                JcrRepositoryPerformanceTest.this.print("Node with history:");
                JcrRepositoryPerformanceTest.this.printNode(assetNode);
                JcrRepositoryPerformanceTest.this.printSubgraph((Node)versionHistory);
            }
        }
    }

    protected class ModifyAsset
    extends DroolsOperation {
        private String path;

        public ModifyAsset(String path) {
            this.path = path;
        }

        public void run(Session s) throws RepositoryException {
            Node assetNode = s.getNode(this.path);
            this.checkout(assetNode);
            this.updateDescription(assetNode, "This is the new description");
            this.checkin(assetNode, "First change");
        }
    }

    protected class ViewContent
    extends DroolsOperation {
        private String path;
        private String content;

        public ViewContent(String path) {
            this.path = path;
        }

        public void run(Session s) throws Exception {
            Node node = s.getNode(this.path);
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            this.content = this.readBinaryContentAttachment(node);
        }

        public String getContent() {
            return this.content;
        }
    }

    protected class VerifyContent
    extends ModeShapeUnitTest.BasicOperation {
        protected VerifyContent() {
            super((ModeShapeUnitTest)JcrRepositoryPerformanceTest.this);
        }

        public void run(Session s) throws Exception {
            this.assertNode(s, "/drools:repository", "nt:folder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area", "nt:folder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area/mortgages", "drools:packageNodeType", new String[0]);
            this.assertNode(s, "/drools:repository/drools:package_area/mortgages/assets", "drools:versionableAssetFolder", new String[0]);
            this.assertNode(s, "/drools:repository/drools:state_area/Draft", "drools:stateNodeType", new String[0]);
            this.assertNode(s, "/drools:repository/drools:tag_area/Home Mortgage", "drools:categoryNodeType", new String[0]);
        }
    }
}

