/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.sequencer.SequencingService;

public class DdlIntegrationTestUtil {
    public JcrEngine engine;
    public Session session;
    public JcrTools tools;
    public static final String ddlTestResourceRootFolder = "org/modeshape/test/integration/sequencer/ddl/";
    protected boolean print = false;

    protected URL getUrl(String urlStr) {
        return this.getClass().getClassLoader().getResource(urlStr);
    }

    public void uploadFile(String folder, String fileName, String testMethod) throws RepositoryException, IOException {
        URL url = this.getUrl(folder + fileName);
        this.uploadFile(url);
    }

    public void uploadFile(URL url) throws RepositoryException, IOException {
        String filename = url.getPath().replaceAll("([^/]*/)*", "");
        String nodePath = "/a/b/" + filename;
        this.tools.uploadFile(this.session, nodePath, url);
        this.session.save();
    }

    public SequencingService.Statistics getStatistics() {
        return this.engine.getSequencingService().getStatistics();
    }

    public void waitUntilSequencedNodesIs(int totalNumberOfNodesSequenced) throws InterruptedException {
        this.waitUntilSequencedNodesIs(totalNumberOfNodesSequenced, 5);
    }

    public void waitUntilSequencedNodesIs(int totalNumberOfNodesSequenced, int numberOfSeconds) throws InterruptedException {
        long numFound = 0L;
        int actualMillis = 0;
        int numberOfMillis = numberOfSeconds * 1000;
        int numberOfIterations = numberOfMillis / 100;
        for (int i = 0; i != numberOfIterations; ++i) {
            numFound = this.getStatistics().getNumberOfNodesSequenced();
            if (numFound >= (long)totalNumberOfNodesSequenced) {
                return;
            }
            Thread.sleep(100L);
            actualMillis += 100;
        }
        Assert.fail((String)("Expected to find " + totalNumberOfNodesSequenced + " nodes sequenced, but found " + numFound));
    }

    public void verifyChildNode(Node parentNode, String childNodeName, String propName, String expectedValue) throws Exception {
        Node childNode = null;
        NodeIterator iter = parentNode.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (!nextNode.getName().equals(childNodeName)) continue;
            childNode = nextNode;
            break;
        }
        if (childNode != null) {
            Assert.assertThat((Object)childNode.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(childNode, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + childNodeName + " not found"));
        }
    }

    public void verifyNode(Node topNode, String name, String propName) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    public void verifySimpleStringProperty(Node node, String propName, String expectedValue) throws Exception {
        Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
        this.verifySingleValueProperty(node, propName, expectedValue);
    }

    public void verifyNode(Node topNode, String name, String propName, String expectedValue) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(node, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    public void verifyNode(Node topNode, String name, String propName, int expectedValue) throws Exception {
        Node node = this.findNode(topNode, name);
        if (node != null) {
            Assert.assertThat((Object)node.hasProperty(propName), (Matcher)Is.is((Object)true));
            this.verifySingleValueProperty(node, propName, expectedValue);
        } else {
            Assert.fail((String)("NODE: " + name + " not found"));
        }
    }

    protected Value value(String value) throws Exception {
        return this.session.getValueFactory().createValue(value);
    }

    public void verifySingleValueProperty(Node node, String propNameStr, String expectedValue) throws Exception {
        if (node == null) {
            return;
        }
        Value expValue = this.value(expectedValue);
        Property prop = node.getProperty(propNameStr);
        if (prop.getDefinition().isMultiple()) {
            Value[] values;
            boolean hasValue = false;
            for (Value val : values = prop.getValues()) {
                if (!val.equals(expValue)) continue;
                hasValue = true;
            }
            Assert.assertThat((Object)hasValue, (Matcher)Is.is((Object)true));
        } else {
            Value actualValue = prop.getValue();
            Assert.assertThat((Object)expValue, (Matcher)Is.is((Object)actualValue));
        }
    }

    public void verifySingleValueProperty(Node node, String propNameStr, int expectedValue) throws Exception {
        Property prop = node.getProperty(propNameStr);
        Value expValue = this.session.getValueFactory().createValue((long)expectedValue);
        Value actualValue = prop.getValue();
        Assert.assertThat((Object)expValue, (Matcher)Is.is((Object)actualValue));
    }

    public void verifyMixin(Node topNode, String nodeName, String nodeType) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            this.verifyMixin(node, nodeType);
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    public boolean hasMixin(Node node, String nodeType) throws Exception {
        for (NodeType mixin : node.getMixinNodeTypes()) {
            String mixinName = mixin.getName();
            if (!mixinName.equals(nodeType)) continue;
            return true;
        }
        return false;
    }

    public void verifyMixin(Node node, String nodeType) throws Exception {
        boolean foundMixin = this.hasMixin(node, nodeType);
        Assert.assertThat((Object)foundMixin, (Matcher)Is.is((Object)true));
    }

    public void verifyNodeType(Node topNode, String nodeName, String nodeTypeName) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            Assert.assertThat((Object)node.isNodeType(nodeTypeName), (Matcher)Is.is((Object)true));
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    public void verifyNodeTypes(Node topNode, String nodeName, String nodeTypeName, String ... moreNodeTypeNames) throws Exception {
        Node node = this.findNode(topNode, nodeName);
        if (node != null) {
            Assert.assertThat((Object)node.isNodeType(nodeTypeName), (Matcher)Is.is((Object)true));
            for (String nextTypeName : moreNodeTypeNames) {
                Assert.assertThat((Object)node.isNodeType(nextTypeName), (Matcher)Is.is((Object)true));
            }
        } else {
            Assert.fail((String)("NODE: " + nodeName + " not found"));
        }
    }

    public Node findNode(Node node, String name) throws Exception {
        if (node.getName().equals(name)) {
            return node;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (nextNode.getName().equals(name)) {
                return nextNode;
            }
            Node someNode = this.findNode(nextNode, name);
            if (someNode == null) continue;
            return someNode;
        }
        return null;
    }

    public Node findNode(Node node, String name, String type) throws Exception {
        if (node.getName().equals(name) && node.isNodeType(type)) {
            return node;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node nextNode = iter.nextNode();
            if (nextNode.getName().equals(name) && nextNode.isNodeType(type)) {
                return nextNode;
            }
            Node someNode = this.findNode(nextNode, name, type);
            if (someNode == null) continue;
            return someNode;
        }
        return null;
    }

    public Node assertNode(Node node, String name, String type) throws Exception {
        Node existingNode = this.findNode(node, name, type);
        Assert.assertNotNull((Object)node);
        return existingNode;
    }

    public void printPropertiesRecursive(Node node) throws RepositoryException, PathNotFoundException, ValueFormatException {
        this.printProperties(node);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.printPropertiesRecursive(iter.nextNode());
        }
    }

    public void printChildProperties(Node node) throws RepositoryException, PathNotFoundException, ValueFormatException {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.printProperties(iter.nextNode());
        }
    }

    public void printProperties(Node node) throws RepositoryException, PathNotFoundException, ValueFormatException {
        System.out.println("\n >>>  NODE PATH: " + node.getPath());
        System.out.println("           NAME: " + node.getName() + "\n");
        PropertyIterator propertyIter = node.getProperties();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.nextProperty();
            String name = property.getName();
            String stringValue = null;
            if (property.getDefinition().isMultiple()) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (!first) {
                        sb.append(", ");
                        first = false;
                    }
                    sb.append(value.getString());
                }
                stringValue = sb.toString();
            } else {
                stringValue = property.getValue().getString();
            }
            System.out.println("   | PROP: " + name + "  VALUE: " + stringValue);
        }
    }

    public void printStart(String fileName, String testMethod) {
        System.out.println("STARTED:  " + testMethod + "(" + fileName + ")");
    }

    public void printEnd(String fileName, String testMethod) {
        System.out.println("ENDED:    " + testMethod + "(" + fileName + ")");
    }

    protected void printSubgraph(Node node) throws RepositoryException {
        this.printSubgraph(node, Integer.MAX_VALUE);
    }

    protected void printSubgraph(Node node, int maxDepth) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), maxDepth);
    }

    protected void printNode(Node node) throws RepositoryException {
        this.printSubgraph(node, " ", node.getDepth(), 1);
    }

    private void printSubgraph(Node node, String lead, int depthOfSubgraph, int maxDepthOfSubgraph) throws RepositoryException {
        if (!this.print) {
            return;
        }
        int currentDepth = node.getDepth() - depthOfSubgraph + 1;
        if (currentDepth > maxDepthOfSubgraph) {
            return;
        }
        if (lead == null) {
            lead = "";
        }
        String nodeLead = lead + StringUtil.createString((char)' ', (int)((currentDepth - 1) * 2));
        StringBuilder sb = new StringBuilder();
        sb.append(nodeLead);
        if (node.getDepth() == 0) {
            sb.append("/");
        } else {
            sb.append(node.getName());
            if (node.getIndex() != 1) {
                sb.append('[').append(node.getIndex()).append(']');
            }
        }
        sb.append(" jcr:primaryType=" + node.getPrimaryNodeType().getName());
        boolean referenceable = false;
        if (node.getMixinNodeTypes().length != 0) {
            sb.append(" jcr:mixinTypes=[");
            boolean first = true;
            for (NodeType mixin : node.getMixinNodeTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(mixin.getName());
                if (!mixin.getName().equals("mix:referenceable")) continue;
                referenceable = true;
            }
            sb.append(']');
        }
        if (referenceable) {
            sb.append(" jcr:uuid=" + node.getIdentifier());
        }
        System.out.println(sb);
        LinkedList<String> propertyNames = new LinkedList<String>();
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property property = iter.nextProperty();
            String name = property.getName();
            if (name.equals("jcr:primaryType") || name.equals("jcr:mixinTypes") || name.equals("jcr:uuid")) continue;
            propertyNames.add(property.getName());
        }
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            boolean binary;
            Property property = node.getProperty(propertyName);
            sb = new StringBuilder();
            sb.append(nodeLead).append("  - ").append(propertyName).append('=');
            boolean bl = binary = property.getType() == 2;
            if (property.isMultiple()) {
                sb.append('[');
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    if (binary) {
                        sb.append(value.getBinary());
                        continue;
                    }
                    sb.append(value.getString());
                }
                sb.append(']');
            } else {
                Value value = property.getValue();
                if (binary) {
                    sb.append(value.getBinary());
                } else {
                    sb.append(value.getString());
                }
            }
            System.out.println(sb);
        }
        if (currentDepth < maxDepthOfSubgraph) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                this.printSubgraph(child, lead, depthOfSubgraph, maxDepthOfSubgraph);
            }
        }
    }

    public class MyCustomSecurityContext
    implements SecurityContext {
        public String getUserName() {
            return "Fred";
        }

        public boolean hasRole(String roleName) {
            return true;
        }

        public void logout() {
        }
    }
}

