/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.text.ParsingException;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.test.integration.sequencer.ddl.DdlIntegrationTestUtil;

public class DdlSequencerIntegrationTest
extends DdlIntegrationTestUtil {
    private JcrConfiguration config;
    private String repositoryName;
    private String workspaceName;

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.tools = new JcrTools();
        this.repositoryName = "ddlRepository";
        this.workspaceName = "default";
        String repositorySource = "ddlRepositorySource";
        this.config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", this.workspaceName);
        this.config.repository(this.repositoryName).addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).registerNamespace("ddl", "http://www.modeshape.org/ddl/1.0").setSource(repositorySource);
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)this.config.sequencer("DDL Sequencer").usingClass("org.modeshape.sequencer.ddl.DdlSequencer").loadedFromClasspath()).setDescription("Sequences DDL files to extract individual statements and accompanying statement properties and values")).sequencingFrom("(//(*.(ddl)[*]))/jcr:content[@jcr:data]").andOutputtingTo("/ddls/$1");
        this.config.save();
        this.engine = this.config.build();
        this.engine.start();
        this.session = this.engine.getRepository(this.repositoryName).login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new DdlIntegrationTestUtil.MyCustomSecurityContext()), this.workspaceName);
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldSequenceCreateSchemaDdlFile() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "create_schema.ddl", "shouldSequenceCreateSchemaDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls") && root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls");
            this.printSubgraph(ddlsNode);
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                this.verifyNode(ddlNode, "hollywood", "ddl:startLineNumber");
                this.verifyNode(ddlNode, "winners", "ddl:expression");
                this.verifyNode(ddlNode, "title", "ddl:datatypeLength");
            }
        }
    }

    @Test
    public void shouldSequenceStandardDdlFile() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "standard_test_statements.ddl", "shouldSequenceStandardDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)44L, (long)numStatements);
                Node stmtNode = this.assertNode(ddlNode, "assertNotNull", "ddl:createAssertionStatement");
                Node constraintAttribute = this.assertNode(stmtNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
                this.verifySingleValueProperty(constraintAttribute, "ddl:propValue", "NOT DEFERRABLE");
                stmtNode = this.assertNode(ddlNode, "assertIsZero", "ddl:createAssertionStatement");
                constraintAttribute = this.assertNode(stmtNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
                this.verifySingleValueProperty(constraintAttribute, "ddl:propValue", "INITIALLY DEFERRED");
                Node tbleNode = this.assertNode(ddlNode, "employee", "ddl:createTableStatement");
                Node columnNode = this.assertNode(ddlNode, "empname", "ddl:columnDefinition");
                this.verifySingleValueProperty(columnNode, "ddl:datatypeName", "CHAR");
                this.verifySingleValueProperty(columnNode, "ddl:datatypeLength", 10);
                Node constraintNode = this.assertNode(tbleNode, "emp_fk1", "ddl:tableConstraint");
                constraintAttribute = this.assertNode(constraintNode, "CONSTRAINT_ATTRIBUTE", "ddl:constraintAttribute");
                this.verifySingleValueProperty(constraintAttribute, "ddl:propValue", "INITIALLY IMMEDIATE");
                this.assertNode(constraintNode, "deptno", "ddl:columnReference");
                this.assertNode(constraintNode, "dept", "ddl:tableReference");
                this.assertNode(constraintNode, "deptno", "ddl:fkColumnReference");
                Node viewNode = this.assertNode(ddlNode, "view_1", "ddl:createViewStatement");
                this.assertNode(viewNode, "col1", "ddl:columnReference");
                Node tableNode = this.assertNode(ddlNode, "table_5", "ddl:createTableStatement");
                Assert.assertEquals((long)18L, (long)tableNode.getNodes().getSize());
            }
        }
    }

    @Test
    public void shouldSequenceStandardDdlGrantStatements() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "grant_test_statements.ddl", "shouldSequenceStandardDdlGrantStatements");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)4L);
                Node grantNode = this.assertNode(ddlNode, "purchaseOrders", "ddl:grantOnTableStatement");
                this.assertNode(grantNode, "maria", "ddl:grantee");
                Node privNode = this.assertNode(grantNode, "privilege", "ddl:grantPrivilege");
                this.verifySingleValueProperty(privNode, "ddl:type", "SELECT");
                grantNode = this.assertNode(ddlNode, "billedOrders", "ddl:grantOnTableStatement");
                privNode = this.assertNode(grantNode, "privilege", "ddl:grantPrivilege");
                this.verifySingleValueProperty(privNode, "ddl:type", "UPDATE");
                this.assertNode(grantNode, "anita", "ddl:grantee");
            }
        }
    }

    @Test
    public void shouldSequenceStandardDdlRevokeStatements() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "revoke_test_statements.ddl", "shouldSequenceStandardDdlRevokeStatements");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)4L);
                Node revokeNode = this.assertNode(ddlNode, "purchaseOrders", "ddl:revokeOnTableStatement");
                this.assertNode(revokeNode, "maria", "ddl:grantee");
                Node privNode = this.assertNode(revokeNode, "privilege", "ddl:grantPrivilege");
                this.verifySingleValueProperty(privNode, "ddl:type", "SELECT");
                revokeNode = this.assertNode(ddlNode, "orderDetails", "ddl:revokeOnTableStatement");
                privNode = this.assertNode(revokeNode, "privilege", "ddl:grantPrivilege");
                this.verifySingleValueProperty(privNode, "ddl:type", "UPDATE");
                this.assertNode(revokeNode, "anita", "ddl:grantee");
            }
        }
    }

    @Test
    public void shouldSequenceStandardAlterTableStatements() throws Exception {
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "alter_table_statements.ddl", "shouldSequenceStandardAlterTableStatements");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)14L);
                Node alterNode = this.assertNode(ddlNode, "table_name_1", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                Node addColumnNode = this.assertNode(alterNode, "column_name", "ddl:columnDefinition");
                this.verifySingleValueProperty(addColumnNode, "ddl:datatypeName", "VARCHAR");
                this.verifySingleValueProperty(addColumnNode, "ddl:datatypeLength", 25);
                this.verifySingleValueProperty(addColumnNode, "ddl:nullable", "NOT NULL");
                alterNode = this.assertNode(ddlNode, "schema_2.table_name_2", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                addColumnNode = this.assertNode(alterNode, "schema_2.table_name_2.column_name", "ddl:columnDefinition");
                this.verifySingleValueProperty(addColumnNode, "ddl:datatypeName", "INTEGER");
                this.verifySingleValueProperty(addColumnNode, "ddl:nullable", "NOT NULL");
                this.verifySingleValueProperty(addColumnNode, "ddl:defaultValue", "25");
                alterNode = this.assertNode(ddlNode, "table_name_4", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                addColumnNode = this.assertNode(alterNode, "column_name", "ddl:alterColumnDefinition");
                this.verifySingleValueProperty(addColumnNode, "ddl:defaultValue", "0");
                alterNode = this.assertNode(ddlNode, "table_name_7", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                Node dropColumnNode = this.assertNode(alterNode, "column_name", "ddl:dropColumnDefinition");
                this.verifySingleValueProperty(dropColumnNode, "ddl:dropBehavior", "RESTRICT");
                alterNode = this.assertNode(ddlNode, "table_name_10", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                Node constraintNode = this.assertNode(alterNode, "pk_name", "ddl:addTableConstraintDefinition");
                this.verifySingleValueProperty(constraintNode, "ddl:constraintType", "PRIMARY KEY");
                this.assertNode(constraintNode, "column_name", "ddl:columnReference");
                alterNode = this.assertNode(ddlNode, "table_name_14", "ddl:alterTableStatement");
                Assert.assertEquals((long)alterNode.getNodes().getSize(), (long)1L);
                Node dropConstraintNode = this.assertNode(alterNode, "fk_name", "ddl:dropTableConstraintDefinition");
                this.verifySingleValueProperty(dropConstraintNode, "ddl:dropBehavior", "RESTRICT");
            }
        }
    }

    @Test
    public void shouldParseUsingCustomGrammarIfGrammarsPropertyIsSetOnDdlSequencerConfiguration() throws Exception {
        this.config.sequencer("DDL Sequencer").setProperty("grammars", ArgleDdlParser.class.getName(), new String[]{"oracle", "standard"});
        this.config.save();
        this.engine = this.config.build();
        this.engine.start();
        this.session = this.engine.getRepository(this.repositoryName).login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new DdlIntegrationTestUtil.MyCustomSecurityContext()), this.workspaceName);
        ArgleDdlParser.parsed = 0;
        ArgleDdlParser.scored = 0;
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "create_schema.ddl", "shouldSequenceCreateSchemaDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Assert.assertThat((Object)ArgleDdlParser.scored, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)ArgleDdlParser.parsed, (Matcher)Is.is((Object)0));
    }

    @Test
    @FixFor(value={"MODE-909"})
    public void shouldBeAbleToCreateAndExecuteJcrSql2QueryWithOrderBy() throws Exception {
        this.engine = this.config.build();
        this.engine.start();
        this.session = this.engine.getRepository(this.repositoryName).login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new DdlIntegrationTestUtil.MyCustomSecurityContext()), this.workspaceName);
        this.uploadFile("org/modeshape/test/integration/sequencer/ddl/", "create_schema.ddl", "shouldBeAbleToCreateAndExecuteJcrSql2QueryWithOrderBy");
        this.waitUntilSequencedNodesIs(1);
        Thread.sleep(800L);
        Query query = this.session.getWorkspace().getQueryManager().createQuery("SELECT [jcr:primaryType] from [nt:base] ORDER BY [jcr:primaryType]", "JCR-SQL2");
        Assert.assertThat((Object)query, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        QueryResult result = query.execute();
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getRows().getSize(), (Matcher)Is.is((Object)16L));
        RowIterator iter = result.getRows();
        String primaryType = "";
        while (iter.hasNext()) {
            Row row = iter.nextRow();
            String nextPrimaryType = row.getValues()[0].getString();
            Assert.assertThat((Object)(nextPrimaryType.compareTo(primaryType) >= 0 ? 1 : 0), (Matcher)Is.is((Object)true));
            primaryType = nextPrimaryType;
        }
    }

    public static class ArgleDdlParser
    extends StandardDdlParser {
        protected static int scored = 0;
        protected static int parsed = 0;

        public String getId() {
            return "ARGLE";
        }

        public Object score(String ddl, String fileName, DdlParserScorer scorer) throws ParsingException {
            ++scored;
            return new Object();
        }

        public void parse(String ddl, AstNode rootNode, Object scoreReturnObject) throws ParsingException {
            ++parsed;
        }
    }
}

