/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.oracle;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.test.integration.sequencer.ddl.DdlIntegrationTestUtil;

public class OracleDdlSequencerIntegrationTest
extends DdlIntegrationTestUtil {
    private String resourceFolder = "org/modeshape/test/integration/sequencer/ddl//dialect/oracle/";

    @Before
    public void beforeEach() throws Exception {
        this.tools = new JcrTools();
        String repositoryName = "ddlRepository";
        String workspaceName = "default";
        String repositorySource = "ddlRepositorySource";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
        config.repository(repositoryName).addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).addNodeTypes(this.getUrl(this.resourceFolder + "OracleDdl.cnd")).registerNamespace("ddl", "http://www.modeshape.org/ddl/1.0").registerNamespace("oracleddl", "http://www.modeshape.org/ddl/oracle/1.0").setSource(repositorySource);
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("DDL Sequencer").usingClass("org.modeshape.sequencer.ddl.DdlSequencer").loadedFromClasspath()).setDescription("Sequences DDL files to extract individual statements and accompanying statement properties and values")).sequencingFrom("(//(*.(ddl)[*]))/jcr:content[@jcr:data]").andOutputtingTo("/ddls/$1");
        config.save();
        this.engine = config.build();
        this.engine.start();
        this.session = this.engine.getRepository(repositoryName).login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new DdlIntegrationTestUtil.MyCustomSecurityContext()), workspaceName);
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldSequenceOracleDdlFile() throws Exception {
        this.uploadFile(this.resourceFolder, "oracle_test_statements.ddl", "shouldSequenceOracleDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)50L);
                this.verifyNode(ddlNode, "address", "ddl:startLineNumber");
                this.verifyNode(ddlNode, "cust_orders", "ddl:expression");
                this.verifyMixin(ddlNode, "cust_orders", "oracleddl:createIndexStatement");
                this.verifyNodeType(ddlNode, "cust_orders", "oracleddl:createIndexStatement");
                this.verifyNodeType(ddlNode, "cust_orders", "ddl:creatable");
                this.verifyNode(ddlNode, "cust_orders", "ddl:startCharIndex", 1698);
                this.verifyNode(ddlNode, "customers_dim", "ddl:startColumnNumber");
            }
        }
    }

    @Test
    public void shouldSequenceOracleCreateProceduresAndFunctions() throws Exception {
        this.uploadFile(this.resourceFolder, "create_procedure_statements.ddl", "shouldSequenceOracleCreateProceduresAndFunctions");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)4L, (long)numStatements);
                Node node = this.assertNode(ddlNode, "remove_emp", "oracleddl:createProcedureStatement");
                Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
                Node paramNode = this.assertNode(node, "employee_id", "oracleddl:functionParameter");
                this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "NUMBER");
                node = this.assertNode(ddlNode, "find_root", "oracleddl:createProcedureStatement");
                Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
                paramNode = this.assertNode(node, "x", "oracleddl:functionParameter");
                this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "REAL");
                this.verifySimpleStringProperty(paramNode, "oracleddl:inOutNoCopy", "IN");
                node = this.assertNode(ddlNode, "SecondMax", "oracleddl:createFunctionStatement");
                Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
                paramNode = this.assertNode(node, "input", "oracleddl:functionParameter");
                this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "NUMBER");
                node = this.assertNode(ddlNode, "text_length", "oracleddl:createFunctionStatement");
                Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
                this.verifySimpleStringProperty(node, "ddl:datatypeName", "NUMBER");
                paramNode = this.assertNode(node, "a", "oracleddl:functionParameter");
                this.verifySimpleStringProperty(paramNode, "ddl:datatypeName", "CLOB");
            }
        }
    }
}

