/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer.ddl.dialect.postgres;

import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.jcr.JcrTools;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.test.integration.sequencer.ddl.DdlIntegrationTestUtil;

public class PostgresDdlSequencerIntegrationTest
extends DdlIntegrationTestUtil {
    private String resourceFolder = "org/modeshape/test/integration/sequencer/ddl//dialect/postgres/";

    @Before
    public void beforeEach() throws Exception {
        this.tools = new JcrTools();
        String repositoryName = "ddlRepository";
        String workspaceName = "default";
        String repositorySource = "ddlRepositorySource";
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource(repositorySource).usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
        config.repository(repositoryName).addNodeTypes(this.getUrl("org/modeshape/sequencer/ddl/StandardDdl.cnd")).addNodeTypes(this.getUrl(this.resourceFolder + "PostgresDdl.cnd")).registerNamespace("ddl", "http://www.modeshape.org/ddl/1.0").registerNamespace("postgresddl", "http://www.modeshape.org/ddl/postgres/1.0").setSource(repositorySource);
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("DDL Sequencer").usingClass("org.modeshape.sequencer.ddl.DdlSequencer").loadedFromClasspath()).setDescription("Sequences DDL files to extract individual statements and accompanying statement properties and values")).sequencingFrom("(//(*.(ddl)[*]))/jcr:content[@jcr:data]").andOutputtingTo("/ddls/$1");
        config.save();
        this.engine = config.build();
        this.engine.start();
        this.session = this.engine.getRepository(repositoryName).login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new DdlIntegrationTestUtil.MyCustomSecurityContext()), workspaceName);
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
    }

    @Test
    public void shouldSequencePostgresDdlFile() throws Exception {
        this.uploadFile(this.resourceFolder, "postgres_test_statements.ddl", "shouldSequencePostgresDdlFile");
        this.waitUntilSequencedNodesIs(1);
        Node root = this.session.getRootNode();
        if (root.hasNode("ddls")) {
            Node ddlsNode = root.getNode("ddls/a/b");
            NodeIterator iter = ddlsNode.getNodes();
            while (iter.hasNext()) {
                Node ddlNode = iter.nextNode();
                long numStatements = ddlNode.getNodes().nextNode().getNodes().getSize();
                Assert.assertEquals((long)numStatements, (long)106L);
                this.verifyNodeType(ddlNode, "increment", "postgresddl:createFunctionStatement");
                this.verifyNode(ddlNode, "increment", "ddl:expression");
                this.verifyNodeType(ddlNode, "increment", "ddl:creatable");
                this.verifyNodeType(ddlNode, "increment", "postgresddl:functionOperand");
                this.verifyNode(ddlNode, "increment", "ddl:startLineNumber", 214);
                this.verifyNode(ddlNode, "increment", "ddl:startCharIndex", 7604);
                this.verifyNodeType(ddlNode, "my_function", "postgresddl:commentOnStatement");
                this.verifyNode(ddlNode, "my_function", "ddl:expression");
                this.verifyNodeType(ddlNode, "my_function", "postgresddl:commentOperand");
                this.verifyNode(ddlNode, "my_function", "ddl:startLineNumber", 44);
                this.verifyNode(ddlNode, "my_function", "ddl:startCharIndex", 1573);
                this.verifyNode(ddlNode, "my_function", "postgresddl:comment", "'Returns Roman Numeral'");
                Node alterTableNode = this.findNode(ddlNode, "foreign_companies", "postgresddl:alterTableStatement");
                Assert.assertNotNull((Object)alterTableNode);
                Node renameColNode = this.findNode(alterTableNode, "address", "postgresddl:renamedColumn");
                Assert.assertNotNull((Object)renameColNode);
                this.verifySingleValueProperty(renameColNode, "ddl:newName", "city");
                Node grantNode = this.findNode(ddlNode, "divideByTwo", "postgresddl:grantOnFunctionStatement");
                Assert.assertNotNull((Object)grantNode);
                Node parameter_1 = this.findNode(grantNode, "numerator", "postgresddl:functionParameter");
                Assert.assertNotNull((Object)parameter_1);
                this.verifySingleValueProperty(parameter_1, "ddl:datatypeName", "int");
            }
        }
    }
}

