/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.svn;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.connector.svn.SvnRepositorySource;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.repository.ModeShapeConfiguration;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class JcrAndLocalSvnRepositoryTest {
    private boolean print;
    private JcrEngine engine;
    private Session session;

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        File source = new File("src/test/resources/svn/local_repos/dummy_svn_repos");
        File target = new File("target/local_svn_repos");
        FileUtil.delete((File)target);
        int num = FileUtil.copy((File)source, (File)target);
        this.print("Copied " + num + " files and directories");
        String repositoryUrl = JcrAndLocalSvnRepositoryTest.svnUrlFor(target);
        Object[] predefinedWorkspaceNames = new String[]{"trunk", "tags"};
        String svnRepositorySource = "svnRepositorySource";
        String repositoryName = "svnRepository";
        JcrConfiguration configuration = new JcrConfiguration();
        ((JcrConfiguration.RepositoryDefinition)((JcrConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("svnRepositorySource").usingClass(SvnRepositorySource.class)).setProperty("password", "")).setProperty("username", "anonymous")).setProperty("repositoryRootUrl", repositoryUrl)).setProperty("predefinedWorkspaceNames", predefinedWorkspaceNames)).setProperty("defaultWorkspaceName", (String)predefinedWorkspaceNames[0])).setProperty("creatingWorkspacesAllowed", false)).setProperty("updatesAllowed", true)).and()).repository("svnRepository").setDescription("The JCR repository backed by a local SVN")).setSource("svnRepositorySource");
        this.engine = configuration.save().and().build();
        this.engine.start();
        this.print("Using local SVN repository " + repositoryUrl);
        this.session = this.engine.getRepository("svnRepository").login((Credentials)new JcrSecurityContextCredentials((SecurityContext)new MyCustomSecurityContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
                if (this.engine != null) {
                    this.engine.shutdown();
                }
            }
        }
    }

    @Test
    public void shouldIterateOverChildrenOfRoot() throws Exception {
        this.print("Getting the root node and it's children (to a maximum depth of 4)...");
        Node root = this.session.getRootNode();
        this.printSubgraph(root, 4, "  ");
        Node h = root.getNode("root/c/h");
        this.assertThatNodeIsFolder(h);
        Node dnaSubmission = root.getNode("root/c/h/JBoss DNA Submission Receipt for JBoss World 2009.pdf");
        this.assertThatNodeIsFile(dnaSubmission, "application/octet-stream", null);
    }

    @Test
    public void shouldAllowingAddingFile() throws Exception {
        Node rootNode = this.session.getRootNode();
        File file = new File("src/test/resources/log4j.properties");
        String fileContent = IoUtil.read((File)file);
        Assert.assertThat((Object)(file.exists() && file.isFile() ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)fileContent, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node fileNode = rootNode.addNode(file.getName(), "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.setProperty("jcr:data", fileContent);
        this.print("## STARTING TO SAVE ##");
        rootNode.getSession().save();
        this.print("## SAVED ##");
    }

    protected void print(String str) {
        if (this.print) {
            System.out.println(str);
        }
    }

    protected void printSubgraph(Node node, int depth, String prefix) throws RepositoryException {
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            this.print((prefix != null ? prefix : " ") + child);
            if (depth <= 1) continue;
            this.printSubgraph(child, depth - 1, prefix);
        }
    }

    public void assertThatNodeIsFolder(Node node) throws RepositoryException {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty("jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:folder"));
    }

    public void assertThatNodeIsFile(Node node, String mimeType, String contents) throws RepositoryException {
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty("jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:file"));
        NodeIterator nodeIterator = node.getNodes();
        Assert.assertThat((Object)(nodeIterator.getSize() >= 1L ? 1 : 0), (Matcher)Is.is((Object)true));
        Node jcrContent = node.getNode("jcr:content");
        Assert.assertThat((Object)jcrContent.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)mimeType));
        if (contents != null) {
            Assert.assertThat((Object)jcrContent.getProperty("jcr:data").getString(), (Matcher)Is.is((Object)contents));
        }
    }

    protected static String svnUrlFor(File directory) throws IOException, SVNException {
        String url = directory.getCanonicalFile().toURI().toURL().toExternalForm();
        url = url.replaceFirst("file:/", "file://localhost/");
        SVNURL encodedUrl = SVNURL.parseURIEncoded((String)url);
        if (!(url = encodedUrl.toDecodedString()).endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    protected class MyCustomSecurityContext
    implements SecurityContext {
        protected MyCustomSecurityContext() {
        }

        public String getUserName() {
            return "Fred";
        }

        public boolean hasRole(String roleName) {
            return true;
        }

        public void logout() {
        }
    }
}

