/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.filesystem;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrTools;
import org.modeshape.test.integration.filesystem.FileSystemRepositoryTest;

public class FileSystemRepositoryWriteTest {
    private static final String TEST_REPOSITORY = "Test Repository Source";
    private static final String TEST_WORKSPACE = "defaultWorkspace";
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private List<Session> sessions = new ArrayList<Session>();
    private boolean print = false;
    private JcrTools tools;

    @Before
    public void beforeAll() throws Exception {
        this.print = false;
        FileSystemRepositoryWriteTest.setupFileSystem("target/test/repository/filesystem", TEST_WORKSPACE, "otherWorkspace");
        this.configuration = new JcrConfiguration();
        this.configuration.loadFrom("src/test/resources/config/configRepositoryForModifiableFileSystem.xml");
        this.engine = this.configuration.build();
        try {
            this.engine.start();
        }
        catch (RuntimeException e) {
            System.err.println("There were problems starting the engine:");
            for (Problem problem : this.engine.getProblems()) {
                System.err.println(problem);
            }
            throw e;
        }
        this.tools = new JcrTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterAll() throws Exception {
        for (Session session : this.sessions) {
            if (!session.isLive()) continue;
            session.logout();
        }
        this.sessions.clear();
        if (this.engine != null) {
            try {
                this.engine.shutdown();
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Test
    @FixFor(value={"MODE-866"})
    public void shouldAllowCreatingNewFolders() throws Exception {
        Session session = this.sessionFrom(this.engine);
        session.getRootNode().addNode("folderA", "nt:folder");
        session.getRootNode().addNode("folderA/folderB", "nt:folder");
        session.save();
        session.getRootNode().addNode("folderA/folderB/folderC", "nt:folder");
        session.save();
        Assert.assertThat((Object)session.getNode("/folderA/folderB/folderC").getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:folder"));
    }

    @Test
    @FixFor(value={"MODE-866"})
    public void shouldAllowCreatingNewFiles() throws Exception {
        Session session = this.sessionFrom(this.engine);
        session.getRootNode().addNode("folderA", "nt:folder");
        session.getRootNode().addNode("folderA/folderB", "nt:folder");
        session.save();
        this.tools.uploadFile(session, "folderA/folderB/log4J.properties", FileSystemRepositoryWriteTest.resourceUrl("log4j.properties"));
        session.save();
        Assert.assertThat((Object)session.getNode("/folderA/folderB").getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:folder"));
        Assert.assertThat((Object)session.getNode("/folderA/folderB/log4J.properties").getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"nt:file"));
        Session session2 = this.sessionFrom(this.engine);
        Binary binary = session2.getProperty("/folderA/folderB/log4J.properties/jcr:content/jcr:data").getBinary();
        Assert.assertThat((Object)IoUtil.read((InputStream)binary.getStream()), (Matcher)Is.is((Object)IoUtil.read((InputStream)FileSystemRepositoryWriteTest.resourceUrl("log4j.properties").openStream())));
    }

    protected Session sessionFrom(JcrEngine engine) throws RepositoryException {
        JcrRepository repository = engine.getRepository(TEST_REPOSITORY);
        Session session = repository.login(TEST_WORKSPACE);
        this.sessions.add(session);
        return session;
    }

    protected String stringFrom(Object object) {
        return (String)this.engine.getExecutionContext().getValueFactories().getStringFactory().create(object);
    }

    protected static void setupFileSystem(String path, String ... workspaceNames) throws Exception {
        File file = new File(path);
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        file.mkdirs();
        for (String workspaceName : workspaceNames) {
            new File(file, workspaceName).mkdir();
        }
    }

    protected static URL resourceUrl(String name) {
        URL url = FileSystemRepositoryTest.class.getClassLoader().getResource(name);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return url;
    }
}

