/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.jpa;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSecurityContextCredentials;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrRepositoryWithJpaConfigurationTest {
    @Test
    public void shouldConfigureWithInMemoryDatabase() throws RepositoryException, PrivilegedActionException {
        this.configureWithInMemoryDatabase(new CustomSecurityContext("bill"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureWithInMemoryDatabase(SecurityContext securityContext) throws RepositoryException, PrivilegedActionException {
        JcrConfiguration configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)configuration.repositorySource("MySource").setDescription("This is my repository source")).usingClass("org.modeshape.connector.store.jpa.JpaSource").loadedFromClasspath()).setProperty("predefinedWorkspaceNames", "workspace1", new String[]{"workspace2", "workspace3"})).setProperty("defaultWorkspaceName", "workspace1")).setProperty("creatingWorkspacesAllowed", true)).setProperty("dialect", "org.hibernate.dialect.HSQLDialect")).setProperty("driverClassName", "org.hsqldb.jdbcDriver")).setProperty("username", "sa")).setProperty("password", "")).setProperty("url", "jdbc:hsqldb:.")).setProperty("maximumConnectionsInPool", 3)).setProperty("minimumConnectionsInPool", 0)).setProperty("numberOfConnectionsToAcquireAsNeeded", 1)).setProperty("maximumSizeOfStatementCache", 100)).setProperty("maximumConnectionIdleTimeInSeconds", 0)).setProperty("largeValueSizeInBytes", 150)).setProperty("compressData", true)).setProperty("referentialIntegrityEnforced", true)).setProperty("autoGenerateSchema", "create")).setProperty("showSql", false);
        ((JcrConfiguration.RepositoryDefinition)configuration.repository("My JCR Repository").setDescription("This is the description for my JCR repository (not really accessible through JCR though)")).setSource("MySource").setOption(JcrRepository.Option.PROJECT_NODE_TYPES, false).setOption(JcrRepository.Option.USE_SECURITY_CONTEXT_CREDENTIALS, true).registerNamespace("myns", "http://www.example.com/some/namespace");
        JcrEngine engine = configuration.build();
        try {
            String[] workspaceNames;
            engine.start();
            JcrRepository myRepository = engine.getRepository("My JCR Repository");
            for (String workspaceName : workspaceNames = new String[]{"workspace2", null}) {
                Session session = null;
                if (securityContext != null) {
                    JcrSecurityContextCredentials credentials = new JcrSecurityContextCredentials(securityContext);
                    session = myRepository.login((Credentials)credentials, workspaceName);
                } else {
                    session = AccessController.doPrivileged(new PrivilegedExceptionAction<Session>((Repository)myRepository, workspaceName){
                        final /* synthetic */ Repository val$myRepository;
                        final /* synthetic */ String val$workspaceName;
                        {
                            this.val$myRepository = repository;
                            this.val$workspaceName = string;
                        }

                        @Override
                        public Session run() throws Exception {
                            return this.val$myRepository.login(this.val$workspaceName);
                        }
                    });
                }
                Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                try {
                    Node root = session.getRootNode();
                    Node jcrSystem = root.getNode("jcr:system");
                    Node namespaces = jcrSystem.getNode("mode:namespaces");
                    assert (namespaces != null);
                    for (int i = 0; i != 10; ++i) {
                        root.addNode("childA", "nt:unstructured");
                    }
                    int childCount = 0;
                    NodeIterator iter = root.getNodes("child* | nonExistant*");
                    while (iter.hasNext()) {
                        Node child = iter.nextNode();
                        Assert.assertThat((Object)child.getName(), (Matcher)Is.is((Object)"childA"));
                        ++childCount;
                    }
                    Assert.assertThat((Object)childCount, (Matcher)Is.is((Object)10));
                }
                finally {
                    session.logout();
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw e;
        }
        finally {
            engine.shutdown();
            try {
                engine.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public static class CustomSecurityContext
    implements SecurityContext {
        private final String username;

        public CustomSecurityContext(String username) {
            this.username = username;
        }

        public String getUserName() {
            return this.username;
        }

        public boolean hasRole(String roleName) {
            return true;
        }

        public void logout() {
        }
    }
}

