/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.ModeShapeUnitTest;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class DeleteDerivedContentIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForCndSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldDeleteDerivedContentWhenOriginalFileIsDeleted() throws Exception {
        for (int i = 0; i != 2; ++i) {
            this.uploadFile("sequencers/cnd/jsr_283_builtins.cnd", "/files/");
            this.waitUntilSequencedNodesIs(1 * (i + 1));
            String derivedPath = "/sequenced/cnd/jsr_283_builtins.cnd";
            Node cnd = this.waitUntilSequencedNodeIsAvailable(derivedPath, "nt:unstructured", new String[0]);
            this.printSubgraph(cnd);
            Node file1 = this.assertNode(derivedPath + "/nt:activity", "nt:nodeType", new String[]{"mode:derived"});
            Assert.assertThat((Object)file1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            this.printQuery("SELECT * FROM [mode:derived]", 34L, new ModeShapeUnitTest.Variable[0]);
            AbstractSequencerTest.DeleteListener listener = this.registerListenerForDeletes();
            String filePath = "/files/jsr_283_builtins.cnd";
            this.assertNode(filePath);
            this.session().removeItem(filePath);
            this.session().save();
            listener.waitForDeleted(5L, TimeUnit.SECONDS, filePath, derivedPath + "/nt:activity", derivedPath + "/nt:base", derivedPath + "/mode:defined", derivedPath + "/mix:referenceable", derivedPath + "/nt:query");
            this.printQuery("SELECT * FROM [mode:derived]", 0L, new ModeShapeUnitTest.Variable[0]);
        }
    }
}

