/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class MSOfficeSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForTextExtraction.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldStartEngineWithRegisteredMSOfficeNodeTypes() throws Exception {
        this.assertNodeType("msoffice:metadata", false, false, true, false, null, 1, 19, new String[]{"nt:unstructured", "mix:mimeType"});
    }

    @Test
    public void shouldSequenceWordDocument() throws Exception {
        this.uploadFile("sequencers/msoffice/Small.doc", "/files/");
        this.waitUntilSequencingFinishes();
        Node sequenced = this.session().getNode("/sequenced");
        Assert.assertThat((Object)sequenced, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.printSubgraph(sequenced);
        Node doc = this.waitUntilSequencedNodeIsAvailable("/sequenced/msoffice/Small.doc", "nt:unstructured", new String[0]);
        this.printSubgraph(doc);
    }
}

