/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.test.integration.sequencer;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.test.integration.sequencer.AbstractSequencerTest;

public class WsdlSequencerIntegrationTest
extends AbstractSequencerTest {
    protected String getPathToDefaultConfiguration() {
        return "config/configRepositoryForWsdlSequencing.xml";
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
        this.session().getWorkspace().getNamespaceRegistry().registerNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_stockQuote() throws Exception {
        this.uploadFile("sequencers/wsdl/stockQuote.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_loanServicePT() throws Exception {
        this.uploadFile("sequencers/wsdl/loanServicePT.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_api_v3_portType() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_api_v3_portType.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_custody_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_custody_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_repl_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_repl_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_repl_v3_portType() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_repl_v3_portType.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_sub_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_sub_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_sub_v3_portType() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_sub_v3_portType.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_sbr_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_subr_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_v3_service() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_v3_service.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_vs_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_vs_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_vs_v3_portType() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_vs_v3_portType.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_vscache_v3_binding() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_vscache_v3_binding.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }

    @Test
    public void shouldGenerateOutputForWsdlInput_uddi_vscache_v3_portType() throws Exception {
        this.uploadFile("sequencers/wsdl/uddi_vscache_v3_portType.wsdl", "/files/");
        this.printSubgraph(this.waitUntilSequencedNodeIsAvailable("/sequenced/wsdl", "nt:unstructured", new String[0]));
    }
}

